/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.SerializationUtils;
import org.mule.raml.implv1.injector.RamlUpdater;
import org.mule.raml.implv1.loader.ApiSyncResourceLoader;
import org.mule.raml.implv1.model.RamlImplV1;
import org.mule.raml.implv1.parser.rule.ValidationResultImpl;
import org.mule.raml.interfaces.ParserType;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.raml.interfaces.injector.IRamlUpdater;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.parser.rule.DefaultValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWrapperV1
implements ParserWrapper {
    public static final ResourceLoader DEFAULT_RESOURCE_LOADER = new DefaultResourceLoader();
    private static final Logger logger = LoggerFactory.getLogger(ParserWrapperV1.class);
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private Raml baseApi;

    public ParserWrapperV1(String ramlPath) {
        this(ramlPath, ParserWrapperV1.getResourceLoaderForPath(ramlPath));
    }

    public ParserWrapperV1(String ramlPath, ResourceLoader ... resourceLoader) {
        this(ramlPath, (ResourceLoader)new CompositeResourceLoader(resourceLoader));
    }

    private ParserWrapperV1(String ramlPath, ResourceLoader resourceLoader) {
        this.ramlPath = ramlPath;
        this.resourceLoader = resourceLoader;
    }

    public static ResourceLoader getResourceLoaderForPath(@Nonnull String ramlPath) {
        if (APISyncUtils.isSyncProtocol((String)ramlPath)) {
            return new ApiSyncResourceLoader(ramlPath);
        }
        File ramlFile = new File(ramlPath);
        FileResourceLoader fileResourceLoader = new FileResourceLoader(ramlFile.getParentFile());
        return new CompositeResourceLoader(new ResourceLoader[]{DEFAULT_RESOURCE_LOADER, fileResourceLoader});
    }

    public ApiVendor getApiVendor() {
        return ApiVendor.RAML_08;
    }

    public ParserType getParserType() {
        return ParserType.RAML;
    }

    public void validate() {
        List results = RamlValidationService.createDefault((ResourceLoader)this.resourceLoader, (TagResolver[])new TagResolver[0]).validate(this.ramlPath);
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new RuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results);
        if (!warnings.isEmpty()) {
            logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    public IValidationReport validationReport() {
        List results = RamlValidationService.createDefault((ResourceLoader)this.resourceLoader, (TagResolver[])new TagResolver[0]).validate(this.ramlPath);
        List validationResults = results.stream().map(ValidationResultImpl::new).collect(Collectors.toList());
        return new DefaultValidationReport(validationResults);
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.ramlPath);
            if (result.getLine() != -1) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public IRaml build() {
        RamlDocumentBuilder builder = new RamlDocumentBuilder(this.resourceLoader, new TagResolver[0]);
        Raml api = (Raml)builder.build(this.ramlPath);
        return new RamlImplV1(api, this.resourceLoader, this.ramlPath);
    }

    public String dump(String ramlContent, IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        String newBaseUri = null;
        if (!oldSchemeHostPort.equals(newSchemeHostPort)) {
            newBaseUri = api.getBaseUri().replace(oldSchemeHostPort, newSchemeHostPort);
        }
        return this.dump(api, newBaseUri);
    }

    public String dump(IRaml api, String newBaseUri) {
        Raml ramlImpl = this.getRamlImpl(api);
        if (newBaseUri != null) {
            Raml clone = this.shallowCloneRaml(ramlImpl);
            clone.setBaseUri(newBaseUri);
            ramlImpl = clone;
        }
        return new RamlEmitter().dump(ramlImpl);
    }

    private Raml shallowCloneRaml(Raml source) {
        try {
            return (Raml)BeanUtils.cloneBean((Object)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IRamlUpdater getRamlUpdater(IRaml api) {
        if (this.baseApi == null) {
            this.baseApi = this.deepCloneRaml(this.getRamlImpl(api));
        }
        return new RamlUpdater(this.deepCloneRaml(this.baseApi));
    }

    public void updateBaseUri(IRaml api, String baseUri) {
        Raml ramlImpl = this.getRamlImpl(api);
        ramlImpl.setBaseUri(baseUri);
        this.cleanBaseUriParameters(ramlImpl);
    }

    private void cleanBaseUriParameters(Raml ramlApi) {
        ramlApi.getBaseUriParameters().clear();
        this.cleanBaseUriParameters(ramlApi.getResources());
    }

    private void cleanBaseUriParameters(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            resource.getBaseUriParameters().clear();
            for (Action action : resource.getActions().values()) {
                action.getBaseUriParameters().clear();
            }
            if (resource.getResources().isEmpty()) continue;
            this.cleanBaseUriParameters(resource.getResources());
        }
    }

    private Raml getRamlImpl(IRaml api) {
        return ((RamlImplV1)api).getRaml();
    }

    private Raml deepCloneRaml(Raml source) {
        Raml target = (Raml)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)source));
        this.copyCompiledSchemas(source, target);
        return target;
    }

    private void copyCompiledSchemas(Raml source, Raml target) {
        target.setCompiledSchemas(source.getCompiledSchemas());
    }
}

