/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.mule.raml.implv1.parser.visitor.RamlDocumentBuilderImpl;
import org.mule.raml.implv1.parser.visitor.RamlValidationServiceImpl;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.visitor.IRamlDocumentBuilder;
import org.mule.raml.interfaces.parser.visitor.IRamlValidationService;
import org.raml.parser.loader.ResourceLoader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ParserV1Utils {
    private static final Yaml YAML_PARSER = new Yaml();
    private static final String INCLUDE_KEYWORD = "!include";

    public static List<String> validate(ResourceLoader resourceLoader, String rootFileName, String resourceContent) {
        return ParserV1Utils.validate(null, resourceLoader, rootFileName, resourceContent);
    }

    public static List<String> validate(String resourceFolder, String rootFileName, String resourceContent) {
        return ParserV1Utils.validate(resourceFolder, null, rootFileName, resourceContent);
    }

    public static IRaml build(String content, String resourceFolder, String rootFileName) {
        return ParserV1Utils.build(content, resourceFolder, null, rootFileName);
    }

    public static IRaml build(String content, ResourceLoader resourceLoader, String rootFileName) {
        return ParserV1Utils.build(content, null, resourceLoader, rootFileName);
    }

    private static List<String> validate(String resourceFolder, ResourceLoader resourceLoader, String rootFileName, String resourceContent) {
        IRamlDocumentBuilder ramlDocumentBuilder = ParserV1Utils.getIRamlDocumentBuilder(resourceFolder, resourceLoader);
        ArrayList<String> errorsList = new ArrayList<String>();
        RamlValidationServiceImpl validationService = new RamlValidationServiceImpl(ramlDocumentBuilder);
        IRamlValidationService result = validationService.validate(resourceContent, rootFileName);
        for (IValidationResult validationResult : result.getErrors()) {
            errorsList.add(validationResult.getMessage());
        }
        return errorsList;
    }

    public static IRaml build(String content, String resourceFolder, ResourceLoader resourceLoader, String rootFileName) {
        IRamlDocumentBuilder ramlDocumentBuilder = ParserV1Utils.getIRamlDocumentBuilder(resourceFolder, resourceLoader);
        return ramlDocumentBuilder.build(content, rootFileName);
    }

    private static IRamlDocumentBuilder getIRamlDocumentBuilder(String resourceFolder, ResourceLoader resourceLoader) {
        RamlDocumentBuilderImpl ramlDocumentBuilder = resourceLoader == null ? new RamlDocumentBuilderImpl() : new RamlDocumentBuilderImpl(resourceLoader);
        if (resourceFolder != null) {
            ramlDocumentBuilder.addPathLookupFirst(resourceFolder);
        }
        return ramlDocumentBuilder;
    }

    public static List<String> detectIncludes(String ramlPath, ResourceLoader resourceLoader) throws IOException {
        try {
            String content = IOUtils.toString((InputStream)resourceLoader.fetchResource(ramlPath));
            String rootFilePath = ramlPath.substring(0, ramlPath.lastIndexOf(File.separator));
            Node rootNode = YAML_PARSER.compose((Reader)new StringReader(content));
            if (rootNode == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(ParserV1Utils.includedFilesIn(rootFilePath, rootNode, resourceLoader));
        }
        catch (MarkedYAMLException e) {
            return Collections.emptyList();
        }
    }

    private static Set<String> includedFilesIn(String rootFileUri, Node rootNode, ResourceLoader resourceLoader) throws IOException {
        HashSet<String> includedFiles;
        block7: {
            block6: {
                includedFiles = new HashSet<String>();
                if (rootNode.getNodeId() != NodeId.scalar) break block6;
                ScalarNode includedNode = (ScalarNode)rootNode;
                Tag nodeTag = includedNode.getTag();
                if (nodeTag == null || !nodeTag.toString().equals(INCLUDE_KEYWORD)) break block7;
                String includedNodeValue = includedNode.getValue();
                String includeUri = rootFileUri + "/" + includedNodeValue;
                String normalized = includeUri.replace("/", File.separator);
                if (resourceLoader.fetchResource(normalized) != null) {
                    includedFiles.add(normalized);
                    includedFiles.addAll(ParserV1Utils.detectIncludes(normalized, resourceLoader));
                }
                break block7;
            }
            if (rootNode.getNodeId() == NodeId.mapping) {
                MappingNode mappingNode = (MappingNode)rootNode;
                List children = mappingNode.getValue();
                for (NodeTuple childNode : children) {
                    Node valueNode = childNode.getValueNode();
                    includedFiles.addAll(ParserV1Utils.includedFilesIn(rootFileUri, valueNode, resourceLoader));
                }
            } else if (rootNode.getNodeId() == NodeId.sequence) {
                SequenceNode sequenceNode = (SequenceNode)rootNode;
                List children = sequenceNode.getValue();
                for (Node childNode : children) {
                    includedFiles.addAll(ParserV1Utils.includedFilesIn(rootFileUri, childNode, resourceLoader));
                }
            }
        }
        return includedFiles;
    }
}

