/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv1;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apikit.ApiParser;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.implv1.loader.ApiSyncResourceLoader;
import org.mule.apikit.implv1.loader.ParserV1FileResourceLoader;
import org.mule.apikit.implv1.model.RamlImplV1;
import org.mule.apikit.implv1.parser.rule.ApiValidationResultImpl;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.apikit.validation.DefaultApiValidationReport;
import org.raml.model.Raml;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;

public class ParserWrapperV1
implements ApiParser {
    public static final ResourceLoader DEFAULT_RESOURCE_LOADER = new DefaultResourceLoader();
    private final String originalPath;
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private final List<String> references;

    public ParserWrapperV1(String ramlPath, List<String> references) {
        this(ramlPath, Collections.emptyList(), references);
    }

    public ParserWrapperV1(String ramlPath, List<ResourceLoader> loaders, List<String> references) {
        this.originalPath = ramlPath;
        this.ramlPath = ParserWrapperV1.findRamlPath(ramlPath).orElse(ramlPath);
        this.references = references;
        this.resourceLoader = new CompositeResourceLoader((ResourceLoader[])ImmutableList.builder().addAll(loaders).add((Object)ParserWrapperV1.getResourceLoaderForPath(this.ramlPath)).build().toArray((Object[])new ResourceLoader[0]));
    }

    public static ResourceLoader getResourceLoaderForPath(String ramlPath) {
        if (ApiSyncUtils.isSyncProtocol((String)ramlPath)) {
            return new ApiSyncResourceLoader(ramlPath);
        }
        File parentFile = new File(ramlPath).getParentFile();
        ParserV1FileResourceLoader parserV1FileResourceLoader = new ParserV1FileResourceLoader(parentFile);
        FileResourceLoader parserFileLoader = new FileResourceLoader(parentFile);
        return new CompositeResourceLoader(new ResourceLoader[]{DEFAULT_RESOURCE_LOADER, parserFileLoader, parserV1FileResourceLoader});
    }

    public ApiValidationReport validate() {
        List results = RamlValidationService.createDefault((ResourceLoader)this.resourceLoader, (TagResolver[])new TagResolver[0]).validate(this.ramlPath);
        List validationResults = results.stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
        return new DefaultApiValidationReport(validationResults);
    }

    public ApiSpecification parse() {
        RamlDocumentBuilder builder = new RamlDocumentBuilder(this.resourceLoader, new TagResolver[0]);
        Raml api = (Raml)builder.build(this.ramlPath);
        return new RamlImplV1(api, this.originalPath, this.references);
    }

    private static Optional<String> findRamlPath(String ramlPath) {
        try {
            if (ApiSyncUtils.isSyncProtocol((String)ramlPath)) {
                return Optional.empty();
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(ramlPath);
            if (url != null && "file".equals(url.getProtocol())) {
                return Optional.of(Paths.get(url.toURI()).toString());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }
}

