/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v08.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.implv2.v08.model.MimeTypeImpl;
import org.mule.apikit.implv2.v08.model.ParameterImpl;
import org.mule.apikit.implv2.v08.model.ResourceImpl;
import org.mule.apikit.implv2.v08.model.ResponseImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.SecurityReference;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.methods.Method;

public class ActionImpl
implements Action {
    private Method method;
    private Map<String, MimeType> bodies;
    private Map<String, Response> responses;
    private Map<String, Parameter> queryParameters;
    private Map<String, Parameter> headers;
    private Map<String, Parameter> resolvedUriParameters;

    public ActionImpl(Method method) {
        this.method = method;
    }

    public ActionType getType() {
        return ActionType.valueOf((String)this.method.method().toUpperCase());
    }

    public boolean hasBody() {
        return !this.getBody().isEmpty();
    }

    public Map<String, Response> getResponses() {
        if (this.responses == null) {
            this.responses = ActionImpl.loadResponses(this.method);
        }
        return this.responses;
    }

    private static Map<String, Response> loadResponses(Method method) {
        LinkedHashMap<String, Response> result = new LinkedHashMap<String, Response>();
        for (org.raml.v2.api.model.v08.bodies.Response response : method.responses()) {
            result.put(response.code().value(), new ResponseImpl(response));
        }
        return result;
    }

    public Map<String, MimeType> getBody() {
        if (this.bodies == null) {
            this.bodies = ActionImpl.loadBodies(this.method);
        }
        return this.bodies;
    }

    private static Map<String, MimeType> loadBodies(Method method) {
        LinkedHashMap<String, MimeType> result = new LinkedHashMap<String, MimeType>();
        for (BodyLike bodyLike : method.body()) {
            result.put(bodyLike.name(), new MimeTypeImpl(bodyLike));
        }
        return result;
    }

    public Resource getResource() {
        return new ResourceImpl(this.method.resource());
    }

    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.method.resource());
        }
        return this.resolvedUriParameters;
    }

    public QueryString queryString() {
        return null;
    }

    public Map<String, Parameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = ActionImpl.loadQueryParameters(this.method);
        }
        return this.queryParameters;
    }

    private static Map<String, Parameter> loadQueryParameters(Method method) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (org.raml.v2.api.model.v08.parameters.Parameter parameter : method.queryParameters()) {
            result.put(parameter.name(), new ParameterImpl(parameter));
        }
        return result;
    }

    public Map<String, Parameter> getHeaders() {
        if (this.headers == null) {
            this.headers = this.loadHeaders(this.method);
        }
        return this.headers;
    }

    private Map<String, Parameter> loadHeaders(Method method) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (org.raml.v2.api.model.v08.parameters.Parameter parameter : method.headers()) {
            result.put(parameter.name(), new ParameterImpl(parameter));
        }
        return result;
    }

    public List<SecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, Parameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, Parameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, MimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, Response response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }
}

