/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v08.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.implv2.v08.model.ActionImpl;
import org.mule.apikit.implv2.v08.model.ParameterImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.resources.Resource;

public class ResourceImpl
implements org.mule.apikit.model.Resource {
    private Resource resource;
    private Map<ActionType, Action> actions;
    private Map<String, Parameter> resolvedUriParameters;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public String getRelativeUri() {
        return this.resource.relativeUri().value();
    }

    public String getUri() {
        return this.resource.resourcePath();
    }

    public String getResolvedUri(String version) {
        return ParserUtils.resolveVersion((String)this.getUri(), (String)version);
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public Action getAction(String name) {
        return this.getActions().get(ResourceImpl.getActionKey(name));
    }

    public Map<ActionType, Action> getActions() {
        if (this.actions == null) {
            this.actions = ResourceImpl.loadActions(this.resource);
        }
        return this.actions;
    }

    private static Map<ActionType, Action> loadActions(Resource resource) {
        LinkedHashMap<ActionType, Action> map = new LinkedHashMap<ActionType, Action>();
        for (Method method : resource.methods()) {
            map.put(ResourceImpl.getActionKey(method.method()), new ActionImpl(method));
        }
        return map;
    }

    private static ActionType getActionKey(String method) {
        return ActionType.valueOf((String)method.toUpperCase());
    }

    public Map<String, org.mule.apikit.model.Resource> getResources() {
        HashMap<String, org.mule.apikit.model.Resource> result = new HashMap<String, org.mule.apikit.model.Resource>();
        for (Resource item : this.resource.resources()) {
            result.put(item.relativeUri().value(), new ResourceImpl(item));
        }
        return result;
    }

    public String getDisplayName() {
        return this.resource.displayName();
    }

    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.resource);
        }
        return this.resolvedUriParameters;
    }

    static Map<String, Parameter> loadResolvedUriParameters(Resource resource) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (Resource current = resource; current != null; current = current.parentResource()) {
            for (org.raml.v2.api.model.v08.parameters.Parameter parameter : current.uriParameters()) {
                result.put(parameter.name(), new ParameterImpl(parameter));
            }
        }
        return result;
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }
}

