/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.apikit.implv2.v10.MetadataResolver;
import org.mule.apikit.model.parameter.FileProperties;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.metadata.api.model.MetadataType;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.MarkdownString;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class ParameterImpl
implements Parameter {
    private static final Set<String> NUMBER_DATA_TYPES = ImmutableSet.of((Object)TypeId.NUMBER.getType(), (Object)TypeId.INTEGER.getType());
    private static final Set<String> BOOLEAN_DATA_TYPES = ImmutableSet.of((Object)TypeId.BOOLEAN.getType());
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;
    private Boolean required;
    private Optional<String> defaultValue;
    private final Boolean typeNeedsQuotes;

    public ParameterImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet typeIds = Sets.newHashSet((Object[])TypeId.values());
        typeIds.remove(TypeId.OBJECT);
        typeIds.remove(TypeId.ARRAY);
        this.scalarTypes = Collections2.transform((Collection)typeIds, TypeId::getType);
        this.typeNeedsQuotes = this.needsQuotes(typeDeclaration);
    }

    public boolean validate(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    public String message(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty() ? "OK" : ((ValidationResult)results.get(0)).getMessage();
    }

    public boolean isRequired() {
        if (this.required == null) {
            this.required = this.typeDeclaration.required();
        }
        return this.required;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = Optional.ofNullable(this.typeDeclaration.defaultValue());
        }
        return this.defaultValue.orElse(null);
    }

    public boolean isRepeat() {
        return false;
    }

    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public String getDisplayName() {
        AnnotableStringType type = this.typeDeclaration.displayName();
        return type == null ? null : type.value();
    }

    public String getDescription() {
        MarkdownString description = this.typeDeclaration.description();
        return description == null ? null : description.value();
    }

    public String getExample() {
        if (this.typeDeclaration.example() == null) {
            return null;
        }
        return this.typeDeclaration.example().value();
    }

    public Map<String, String> getExamples() {
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (ExampleSpec example : this.typeDeclaration.examples()) {
            examples.put(example.name(), example.value());
        }
        return examples;
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public MetadataType getMetadata() {
        return MetadataResolver.resolve(this.typeDeclaration).orElse(MetadataResolver.anyType());
    }

    public boolean isScalar() {
        return ParameterImpl.isOfType(this.typeDeclaration, this.scalarTypes);
    }

    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }

    public String surroundWithQuotesIfNeeded(String value) {
        return value != null && (value.startsWith("*") || this.typeNeedsQuotes != false) ? ParameterImpl.quote(value) : value;
    }

    public Optional<FileProperties> getFileProperties() {
        if (this.typeDeclaration instanceof FileTypeDeclaration) {
            FileTypeDeclaration fileTypeDeclaration = (FileTypeDeclaration)this.typeDeclaration;
            Integer minLength = fileTypeDeclaration.minLength() != null ? fileTypeDeclaration.minLength().intValue() : 0;
            Integer maxLength = fileTypeDeclaration.maxLength() != null ? fileTypeDeclaration.maxLength().intValue() : 0;
            List fileTypes = fileTypeDeclaration.fileTypes() != null ? fileTypeDeclaration.fileTypes() : Collections.emptyList();
            return Optional.of(new FileProperties(minLength, maxLength, new HashSet(fileTypes)));
        }
        return Optional.empty();
    }

    private static boolean isOfType(TypeDeclaration type, Collection<String> typesCollection) {
        return typesCollection.contains(type.type()) || type.parentTypes() != null && !type.parentTypes().isEmpty() && type.parentTypes().stream().anyMatch(pt -> typesCollection.contains(pt.type()));
    }

    private boolean needsQuotes(TypeDeclaration typeDeclaration) {
        TypeDeclaration type = typeDeclaration;
        if (type instanceof ArrayTypeDeclaration ? (type = ((ArrayTypeDeclaration)type).items()) instanceof ObjectTypeDeclaration || type instanceof ArrayTypeDeclaration : !ParameterImpl.isOfType(type, this.scalarTypes)) {
            return Boolean.FALSE;
        }
        return !ParameterImpl.isOfType(type, NUMBER_DATA_TYPES) && !ParameterImpl.isOfType(type, BOOLEAN_DATA_TYPES);
    }

    static String quote(String payload) {
        return "\"" + payload + "\"";
    }
}

