/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ApiType;
import org.mule.apikit.common.RamlUtils;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.implv2.v10.model.ResourceImpl;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.SecurityScheme;
import org.mule.apikit.model.Template;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.internal.utils.StreamUtils;

public class RamlImpl10V2
implements ApiSpecification {
    private final Api api;
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private List<String> references;

    public RamlImpl10V2(Api api, ResourceLoader resourceLoader, String ramlPath, List<String> references) {
        this.api = api;
        this.ramlPath = ramlPath;
        this.resourceLoader = resourceLoader;
        this.references = references;
    }

    public Map<String, org.mule.apikit.model.Resource> getResources() {
        LinkedHashMap<String, org.mule.apikit.model.Resource> map = new LinkedHashMap<String, org.mule.apikit.model.Resource>();
        List resources = this.api.resources();
        for (Resource resource : resources) {
            map.put(resource.relativeUri().value(), new ResourceImpl(resource));
        }
        return map;
    }

    public String getBaseUri() {
        return this.api.baseUri() != null ? String.valueOf(this.api.baseUri().value()) : null;
    }

    public String getLocation() {
        return this.ramlPath;
    }

    public String getVersion() {
        return this.api.version() != null ? String.valueOf(this.api.version().value()) : null;
    }

    public List<Map<String, String>> getSchemas() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List types = this.api.types();
        if (types.isEmpty()) {
            types = this.api.schemas();
        }
        for (TypeDeclaration typeDeclaration : types) {
            map.put(typeDeclaration.name(), RamlImpl10V2.getTypeAsString(typeDeclaration));
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        result.add(map);
        return result;
    }

    static String getTypeAsString(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ExternalTypeDeclaration) {
            return ((ExternalTypeDeclaration)typeDeclaration).schemaContent();
        }
        if (typeDeclaration instanceof AnyTypeDeclaration) {
            return null;
        }
        return typeDeclaration.toJsonSchema();
    }

    public org.mule.apikit.model.Resource getResource(String path) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getConsolidatedSchemas() {
        return Collections.emptyMap();
    }

    public Map<String, Object> getCompiledSchemas() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Parameter> getBaseUriParameters() {
        LinkedHashMap<String, Parameter> baseUriParameters = new LinkedHashMap<String, Parameter>();
        this.api.baseUriParameters().forEach(type -> {
            Parameter cfr_ignored_0 = baseUriParameters.put(type.name(), new ParameterImpl((TypeDeclaration)type));
        });
        return baseUriParameters;
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        throw new UnsupportedOperationException();
    }

    public List<Map<String, Template>> getTraits() {
        throw new UnsupportedOperationException();
    }

    public String getUri() {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllReferences() {
        return this.references;
    }

    public String dump(String newBaseUri) {
        InputStream stream = this.resourceLoader.fetchResource(this.ramlPath);
        if (stream != null) {
            String raml = StreamUtils.toString((InputStream)stream);
            if (newBaseUri != null) {
                return RamlUtils.replaceBaseUri((String)raml, (String)newBaseUri);
            }
            return raml;
        }
        throw new RuntimeException("Invalid RAML descriptor");
    }

    public ApiType getType() {
        return ApiType.RAML;
    }

    public ApiVendor getApiVendor() {
        return ApiVendor.RAML_10;
    }
}

