/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.loader;

import java.io.InputStream;
import javax.annotation.Nullable;
import org.mule.apikit.common.ApiSyncUtils;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

public class ApiSyncResourceLoader
implements ResourceLoader {
    private ResourceLoader resourceLoader;
    private String rootRamlResource;

    public ApiSyncResourceLoader(String rootRaml) {
        this(rootRaml, (ResourceLoader)new DefaultResourceLoader());
    }

    public ApiSyncResourceLoader(String rootRaml, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.rootRamlResource = this.getRootRamlResource(rootRaml);
    }

    private String getRootRamlResource(String rootRamlResource) {
        return rootRamlResource.substring(0, rootRamlResource.lastIndexOf(":") + 1);
    }

    @Nullable
    public InputStream fetchResource(String s) {
        InputStream stream = null;
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (ApiSyncUtils.isExchangeModules((String)s)) {
            stream = this.getApiSyncResource(s);
        }
        if (stream != null) {
            return stream;
        }
        if (ApiSyncUtils.isSyncProtocol((String)s)) {
            return this.resourceLoader.fetchResource(s);
        }
        return this.resourceLoader.fetchResource(this.rootRamlResource + s);
    }

    private InputStream getApiSyncResource(String s) {
        String apiSyncResource = ApiSyncUtils.toApiSyncResource((String)s);
        if (apiSyncResource != null) {
            return this.resourceLoader.fetchResource(apiSyncResource);
        }
        return null;
    }
}

