/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces.model.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.api.ApiRef;

class URIApiRef
implements ApiRef {
    private URI uri;
    private Optional<ResourceLoader> resourceLoader;

    URIApiRef(URI uri) {
        this(uri, null);
    }

    URIApiRef(URI uri, ResourceLoader resourceLoader) {
        this.uri = uri;
        this.resourceLoader = Optional.ofNullable(resourceLoader);
    }

    @Override
    public String getLocation() {
        return this.uri.toString();
    }

    @Override
    public String getFormat() {
        return FilenameUtils.getExtension((String)this.uri.getPath()).toUpperCase();
    }

    @Override
    public InputStream resolve() {
        if (this.resourceLoader.isPresent()) {
            return this.resourceLoader.map(loader -> loader.getResourceAsStream(this.getLocation())).orElse(null);
        }
        try {
            return new BufferedInputStream(this.uri.toURL().openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return this.resourceLoader;
    }
}

