/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.loader;

import java.net.URI;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.loader.ClassPathResourceLoader;
import org.mule.apikit.loader.ResourceLoader;

public class ApiSyncResourceLoader
implements ResourceLoader {
    private ResourceLoader resourceLoader;
    private String rootResource;

    public ApiSyncResourceLoader(String resource) {
        this(resource, new ClassPathResourceLoader());
    }

    public ApiSyncResourceLoader(String resource, ResourceLoader resourceLoader) {
        this.rootResource = this.getRootRamlResource(resource);
        this.resourceLoader = resourceLoader;
    }

    @Override
    public URI getResource(String path) {
        String resourcePath = path.startsWith("/") ? path.substring(1) : path;
        if (ApiSyncUtils.isExchangeModules(resourcePath)) {
            return this.resourceLoader.getResource(ApiSyncUtils.toApiSyncResource(resourcePath));
        }
        if (ApiSyncUtils.isSyncProtocol(path)) {
            return this.resourceLoader.getResource(resourcePath);
        }
        return this.resourceLoader.getResource(this.rootResource + resourcePath);
    }

    private String getRootRamlResource(String rootRamlResource) {
        return rootRamlResource.substring(0, rootRamlResource.lastIndexOf(":") + 1);
    }
}

