/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model.api;

import java.io.InputStream;
import java.util.Optional;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.apikit.loader.ApiSyncResourceLoader;
import org.mule.apikit.loader.ClassPathResourceLoader;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;

class ApiSyncApiRef
implements ApiReference {
    private static final String RESOURCE_FORMAT = "resource::%s:%s:%s:%s:%s:%s";
    private String groupId;
    private String artifact;
    private String version;
    private String classifier;
    private String packager;
    private String file;
    private ResourceLoader resourceLoader;

    ApiSyncApiRef(String resource) {
        this(resource, new ClassPathResourceLoader());
    }

    ApiSyncApiRef(String resource, ResourceLoader resourceLoader) {
        this.resourceLoader = new ApiSyncResourceLoader(resource, resourceLoader);
        if (!ApiSyncUtils.isSyncProtocol(resource)) {
            throw new RuntimeException("Invalid APISync Resource");
        }
        String[] parts = resource.substring("resource::".length()).split(":");
        if (parts.length != 6) {
            throw new RuntimeException("Invalid APISync Resource");
        }
        this.groupId = parts[0];
        this.artifact = parts[1];
        this.version = parts[2];
        this.classifier = parts[3];
        this.packager = parts[4];
        this.file = parts[5];
    }

    public boolean equals(ApiSyncApiRef resource, Boolean checkVersion) {
        return this.groupId.equals(resource.groupId) && this.artifact.equals(resource.artifact) && (checkVersion == false || this.version.equals(resource.version)) && this.classifier.equals(resource.classifier) && this.packager.equals(resource.packager) && this.file.equals(resource.file);
    }

    @Override
    public String getLocation() {
        return String.format(RESOURCE_FORMAT, this.groupId, this.artifact, this.version, this.classifier, this.packager, this.file);
    }

    @Override
    public String getFormat() {
        return this.classifier.toUpperCase();
    }

    @Override
    public InputStream resolve() {
        return this.resourceLoader.getResourceAsStream(this.getLocation());
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return Optional.of(this.resourceLoader);
    }
}

