/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.QueryString;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.SecurityReference;
import org.mule.apikit.model.parameter.Parameter;

public interface Action {
    public ActionType getType();

    public Resource getResource();

    public Map<String, MimeType> getBody();

    public Map<String, List<Parameter>> getBaseUriParameters();

    public Map<String, Parameter> getResolvedUriParameters();

    public Map<String, Parameter> getQueryParameters();

    public boolean hasBody();

    public Map<String, Response> getResponses();

    public Map<String, Parameter> getHeaders();

    public List<SecurityReference> getSecuredBy();

    public List<String> getIs();

    public void cleanBaseUriParameters();

    public void setHeaders(Map<String, Parameter> var1);

    public void setQueryParameters(Map<String, Parameter> var1);

    public void setBody(Map<String, MimeType> var1);

    public void addResponse(String var1, Response var2);

    public void addSecurityReference(String var1);

    public void addIs(String var1);

    public QueryString queryString();

    default public String getSuccessStatusCode() {
        Map<String, Response> responses = this.getResponses();
        if (MapUtils.isEmpty(responses) || responses.get("default") != null) {
            return "200";
        }
        for (String status : responses.keySet()) {
            if (!status.startsWith("2")) continue;
            return status;
        }
        return "200";
    }
}

