/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit;

import java.util.Collection;
import java.util.Map;
import org.mule.apikit.model.parameter.Parameter;

public class ParserUtils {
    public static String resolveVersion(String path, String version) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (!path.contains("{version}")) {
            return path;
        }
        if (version == null) {
            throw new IllegalStateException("RAML does not contain version information and is required by resource: " + path);
        }
        return path.replaceAll("\\{version}", version);
    }

    public static String getArrayAsYamlValue(Parameter facet, Collection<?> paramValues) {
        if (paramValues == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        paramValues.forEach(paramValue -> {
            String value = String.valueOf(paramValue);
            builder.append("- ");
            builder.append(facet.surroundWithQuotesIfNeeded(value));
            builder.append("\n");
        });
        return builder.toString();
    }

    public static String queryStringAsYamlValue(Map<String, Parameter> facets, Map<String, Collection<?>> queryParamsCopy) {
        StringBuilder queryStringYaml = new StringBuilder();
        for (String property : queryParamsCopy.keySet()) {
            Parameter facet = facets.get(property.toString());
            if (facet == null) {
                return "";
            }
            Collection<?> actualQueryParam = queryParamsCopy.get(property.toString());
            queryStringYaml.append("\n").append((Object)property).append(": ");
            if (actualQueryParam.size() > 1 || facet.isArray()) {
                for (Object value : actualQueryParam) {
                    queryStringYaml.append("\n  - ").append(facet.surroundWithQuotesIfNeeded(String.valueOf(value)));
                }
                queryStringYaml.append("\n");
                continue;
            }
            for (Object value : actualQueryParam) {
                queryStringYaml.append(facet.surroundWithQuotesIfNeeded(String.valueOf(value))).append("\n");
            }
        }
        return queryStringYaml.toString();
    }

    public static String quoteValue(String payload) {
        return "\"" + payload + "\"";
    }

    public static String escapeSpecialCharsInYamlValue(String value) {
        return value == null ? null : value.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

