/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms.lrc;

import bitronix.tm.internal.BitronixXAException;
import bitronix.tm.utils.Decoder;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LrcXAResource
implements XAResource {
    private static final Logger log = LoggerFactory.getLogger(LrcXAResource.class);
    public static final int NO_TX = 0;
    public static final int STARTED = 1;
    public static final int ENDED = 2;
    public static final int PREPARED = 3;
    private final Session session;
    private volatile Xid xid;
    private volatile int state = 0;

    public LrcXAResource(Session session) {
        this.session = session;
    }

    public int getState() {
        return this.state;
    }

    private String xlatedState() {
        switch (this.state) {
            case 0: {
                return "NO_TX";
            }
            case 1: {
                return "STARTED";
            }
            case 2: {
                return "ENDED";
            }
            case 3: {
                return "PREPARED";
            }
        }
        return "!invalid state (" + this.state + ")!";
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Xid xid, int flag) throws XAException {
        if (flag != 0 && flag != 0x200000) {
            throw new BitronixXAException("unsupported start flag " + Decoder.decodeXAResourceFlag(flag), -3);
        }
        if (xid == null) {
            throw new BitronixXAException("XID cannot be null", -5);
        }
        if (this.state == 0) {
            if (this.xid != null) {
                throw new BitronixXAException("resource already started on XID " + this.xid, -6);
            }
            if (flag == 0x200000) {
                throw new BitronixXAException("resource not yet started", -6);
            }
            if (log.isDebugEnabled()) {
                log.debug("OK to start, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + Decoder.decodeXAResourceFlag(flag));
            }
            this.xid = xid;
        } else {
            if (this.state == 1) {
                throw new BitronixXAException("resource already started on XID " + this.xid, -6);
            }
            if (this.state == 2) {
                if (flag == 0) {
                    throw new BitronixXAException("resource already registered XID " + this.xid, -8);
                }
                if (!xid.equals(this.xid)) throw new BitronixXAException("resource already started on XID " + this.xid + " - cannot start it on more than one XID at a time", -3);
                if (log.isDebugEnabled()) {
                    log.debug("OK to join, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + Decoder.decodeXAResourceFlag(flag));
                }
            } else if (this.state == 3) {
                throw new BitronixXAException("resource already prepared on XID " + this.xid, -6);
            }
        }
        this.state = 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        if (flag != 0x4000000 && flag != 0x20000000) {
            throw new BitronixXAException("unsupported end flag " + Decoder.decodeXAResourceFlag(flag), -3);
        }
        if (xid == null) {
            throw new BitronixXAException("XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new BitronixXAException("resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            if (!this.xid.equals(xid)) throw new BitronixXAException("resource already started on XID " + this.xid + " - cannot end it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug("OK to end, old state=" + this.xlatedState() + ", XID=" + xid + ", flag=" + Decoder.decodeXAResourceFlag(flag));
            }
        } else {
            if (this.state == 2) {
                throw new BitronixXAException("resource already ended on XID " + xid, -6);
            }
            if (this.state == 3) {
                throw new BitronixXAException("cannot end, resource already prepared on XID " + xid, -6);
            }
        }
        if (flag == 0x20000000) {
            try {
                this.session.rollback();
                this.state = 0;
                this.xid = null;
                return;
            }
            catch (JMSException ex) {
                throw new BitronixXAException("error rolling back resource on end", -3, ex);
            }
        }
        this.state = 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new BitronixXAException("XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new BitronixXAException("resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new BitronixXAException("resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!this.xid.equals(xid)) throw new BitronixXAException("resource already started on XID " + this.xid + " - cannot prepare it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug("OK to prepare, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        } else if (this.state == 3) {
            throw new BitronixXAException("resource already prepared on XID " + this.xid, -6);
        }
        try {
            this.session.commit();
            this.state = 3;
            return 0;
        }
        catch (JMSException ex) {
            throw new BitronixXAException("error preparing non-XA resource", -3, ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            throw new BitronixXAException("XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new BitronixXAException("resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new BitronixXAException("resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!onePhase) throw new BitronixXAException("resource never prepared on XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug("OK to commit with 1PC, old state=" + this.xlatedState() + ", XID=" + xid);
            }
            try {
                this.session.commit();
            }
            catch (JMSException ex) {
                throw new BitronixXAException("error committing (one phase) non-XA resource", -3, ex);
            }
        } else if (this.state == 3) {
            if (onePhase) throw new BitronixXAException("cannot commit in one phase as resource has been prepared on XID " + xid, -6);
            if (!this.xid.equals(xid)) throw new BitronixXAException("resource already started on XID " + this.xid + " - cannot commit it on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug("OK to commit, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        }
        this.state = 0;
        this.xid = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new BitronixXAException("XID cannot be null", -5);
        }
        if (this.state == 0) {
            throw new BitronixXAException("resource never started on XID " + xid, -6);
        }
        if (this.state == 1) {
            throw new BitronixXAException("resource never ended on XID " + xid, -6);
        }
        if (this.state == 2) {
            if (!this.xid.equals(xid)) throw new BitronixXAException("resource already started on XID " + this.xid + " - cannot roll it back on another XID " + xid, -6);
            if (log.isDebugEnabled()) {
                log.debug("OK to rollback, old state=" + this.xlatedState() + ", XID=" + xid);
            }
        } else if (this.state == 3) {
            this.state = 0;
            throw new BitronixXAException("resource committed during prepare on XID " + this.xid, 7);
        }
        try {
            this.session.rollback();
            return;
        }
        catch (JMSException ex) {
            throw new BitronixXAException("error preparing non-XA resource", -3, ex);
        }
        finally {
            this.state = 0;
            this.xid = null;
        }
    }

    public String toString() {
        return "a JMS LrcXAResource in state " + this.xlatedState() + " of session " + this.session;
    }
}

