/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.journal.DiskForceBatcherThread;
import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogHeader;
import bitronix.tm.journal.TransactionLogRecord;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.Interruptible;

public class TransactionLogAppender {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogAppender.class);
    public static final int END_RECORD = 2020504642;
    private final File file;
    private final FileChannel fc;
    private final FileLock lock;
    private final TransactionLogHeader header;
    private final long maxFileLength;
    private static volatile DiskForceBatcherThread diskForceBatcherThread;

    public TransactionLogAppender(File file, long maxFileLength) throws IOException {
        this.maxFileLength = maxFileLength;
        this.file = file;
        this.fc = new RandomAccessFile(file, "rw").getChannel();
        this.header = new TransactionLogHeader(this.fc, maxFileLength);
        this.lock = this.fc.tryLock(0L, 4L, false);
        if (this.lock == null) {
            throw new IOException("transaction log file " + file.getName() + " is locked. Is another instance already running?");
        }
        this.spawnBatcherThread();
        this.keepFileChannelOpenOnInterrupt(file.getName(), this.fc);
    }

    public TransactionLogHeader getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeLog(TransactionLogRecord tlog) throws IOException {
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            int recordSize = tlog.calculateTotalRecordSize();
            long futureFilePosition = this.getHeader().getPosition() + (long)recordSize;
            if (futureFilePosition >= this.maxFileLength) {
                if (log.isDebugEnabled()) {
                    log.debug("log file is full (size would be: " + futureFilePosition + ", max allowed: " + this.maxFileLength + ")");
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("between " + this.getHeader().getPosition() + " and " + futureFilePosition + ", writing " + tlog);
            }
            ByteBuffer buf = ByteBuffer.allocate(recordSize);
            buf.putInt(tlog.getStatus());
            buf.putInt(tlog.getRecordLength());
            buf.putInt(tlog.getHeaderLength());
            buf.putLong(tlog.getTime());
            buf.putInt(tlog.getSequenceNumber());
            buf.putInt(tlog.getCrc32());
            buf.put((byte)tlog.getGtrid().getArray().length);
            buf.put(tlog.getGtrid().getArray());
            Set<String> uniqueNames = tlog.getUniqueNames();
            buf.putInt(uniqueNames.size());
            for (String uniqueName : uniqueNames) {
                buf.putShort((short)uniqueName.length());
                buf.put(uniqueName.getBytes());
            }
            buf.putInt(tlog.getEndRecord());
            buf.flip();
            while (buf.hasRemaining()) {
                this.fc.write(buf);
            }
            this.getHeader().goAhead(tlog.calculateTotalRecordSize());
            if (log.isDebugEnabled()) {
                log.debug("disk journal appender now at position " + this.getHeader().getPosition());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            this.shutdownBatcherThread();
            this.getHeader().setState((byte)0);
            this.fc.force(false);
            this.lock.release();
            this.fc.close();
        }
    }

    public TransactionLogCursor getCursor() throws IOException {
        return new TransactionLogCursor(this.file);
    }

    public void force() throws IOException {
        if (!TransactionManagerServices.getConfiguration().isForcedWriteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("disk forces have been disabled");
            }
            return;
        }
        if (!TransactionManagerServices.getConfiguration().isForceBatchingEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("not batching disk force");
            }
            this.doForce();
        } else {
            diskForceBatcherThread.enqueue(this);
        }
    }

    public String toString() {
        return "a TransactionLogAppender on " + this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForce() throws IOException {
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            if (log.isDebugEnabled()) {
                log.debug("forcing log writing");
            }
            this.fc.force(false);
            if (log.isDebugEnabled()) {
                log.debug("done forcing log");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnBatcherThread() {
        Class<TransactionLogAppender> clazz = TransactionLogAppender.class;
        synchronized (TransactionLogAppender.class) {
            if (diskForceBatcherThread != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("spawning disk force batcher thread");
            }
            diskForceBatcherThread = DiskForceBatcherThread.getInstance();
            if (!TransactionManagerServices.getConfiguration().isForcedWriteEnabled()) {
                log.warn("transaction journal disk syncs have been disabled, transaction logs integrity is not guaranteed !");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (!TransactionManagerServices.getConfiguration().isForceBatchingEnabled()) {
                log.warn("transaction journal disk syncs batching has been disabled, this will seriously impact performance !");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownBatcherThread() {
        Class<TransactionLogAppender> clazz = TransactionLogAppender.class;
        synchronized (TransactionLogAppender.class) {
            if (diskForceBatcherThread == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("requesting disk force batcher thread to shutdown");
            }
            diskForceBatcherThread.setAlive(false);
            diskForceBatcherThread.interrupt();
            do {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("waiting for disk force batcher thread to die");
                    }
                    diskForceBatcherThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (diskForceBatcherThread.isInterrupted());
            if (log.isDebugEnabled()) {
                log.debug("disk force batcher thread has shutdown");
            }
            diskForceBatcherThread = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void keepFileChannelOpenOnInterrupt(String aContextInfo, FileChannel aFc) {
        Field field = null;
        try {
            field = AbstractInterruptibleChannel.class.getDeclaredField("interruptor");
            field.setAccessible(true);
            field.set(this.fc, new IgnoreAllInterruptRequests(aContextInfo));
            log.info("Filechannel " + aFc + " is kept open on Thread.interrupt() now.");
        }
        catch (IllegalAccessException | NoSuchFieldException | RuntimeException e) {
            log.warn("Ignore: Cannot set interruptor on " + aFc + " with field=" + field, (Throwable)e);
        }
    }

    private class IgnoreAllInterruptRequests
    implements Interruptible {
        private String contextInfo;

        private IgnoreAllInterruptRequests(String aContextInfo) {
            this.contextInfo = aContextInfo;
        }

        @Override
        public void interrupt(Thread aT) {
            log.info("Keep file channel for " + this.contextInfo + " open even interrupt came from " + aT);
        }
    }
}

