/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        block3: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                try {
                    return cl.loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("context classloader could not find class '" + className + "', trying Class.forName() instead");
                }
            }
        }
        return Class.forName(className);
    }

    public static InputStream getResourceAsStream(String resourceName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl.getResourceAsStream(resourceName);
        }
        return ClassLoaderUtils.class.getClassLoader().getResourceAsStream(resourceName);
    }
}

