/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.ResourceConfigurationException;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.PropertyUtils;
import bitronix.tm.utils.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.XAConnectionFactory;
import javax.sql.XADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader
implements Service {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    private static final String JDBC_RESOURCE_CLASSNAME = "bitronix.tm.resource.jdbc.PoolingDataSource";
    private static final String JMS_RESOURCE_CLASSNAME = "bitronix.tm.resource.jms.PoolingConnectionFactory";
    private final Map<String, XAResourceProducer> resourcesByUniqueName = new HashMap<String, XAResourceProducer>();

    public Map<String, XAResourceProducer> getResources() {
        return this.resourcesByUniqueName;
    }

    public int init() {
        String filename = TransactionManagerServices.getConfiguration().getResourceConfigurationFilename();
        if (filename != null) {
            if (!new File(filename).exists()) {
                throw new ResourceConfigurationException("cannot find resources configuration file '" + filename + "', missing or invalid value of property 'bitronix.tm.resource.configuration'");
            }
            log.info("reading resources configuration from " + filename);
            return this.init(filename);
        }
        if (log.isDebugEnabled()) {
            log.debug("no resource configuration file specified");
        }
        return 0;
    }

    @Override
    public synchronized void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("resource loader has registered " + this.resourcesByUniqueName.entrySet().size() + " resource(s), unregistering them now");
        }
        for (Map.Entry<String, XAResourceProducer> entry : this.resourcesByUniqueName.entrySet()) {
            XAResourceProducer producer = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("closing " + producer);
            }
            try {
                producer.close();
            }
            catch (Exception ex) {
                log.warn("error closing resource " + producer, (Throwable)ex);
            }
        }
        this.resourcesByUniqueName.clear();
    }

    private static XAResourceProducer instantiate(String xaResourceClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = ClassLoaderUtils.loadClass(xaResourceClassName);
        if (XADataSource.class.isAssignableFrom(clazz)) {
            return (XAResourceProducer)ClassLoaderUtils.loadClass(JDBC_RESOURCE_CLASSNAME).newInstance();
        }
        if (XAConnectionFactory.class.isAssignableFrom(clazz)) {
            return (XAResourceProducer)ClassLoaderUtils.loadClass(JMS_RESOURCE_CLASSNAME).newInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int init(String propertiesFilename) {
        try {
            Properties properties;
            try (FileInputStream fis = null;){
                fis = new FileInputStream(propertiesFilename);
                properties = new Properties();
                properties.load(fis);
            }
            return this.initXAResourceProducers(properties);
        }
        catch (IOException ex) {
            throw new InitializationException("cannot create resource loader", ex);
        }
    }

    int initXAResourceProducers(Properties properties) {
        Map<String, List<PropertyPair>> entries = this.buildConfigurationEntriesMap(properties);
        int errorCount = 0;
        for (Map.Entry<String, List<PropertyPair>> entry : entries.entrySet()) {
            List<PropertyPair> propertyPairs;
            String uniqueName = entry.getKey();
            XAResourceProducer producer = this.buildXAResourceProducer(uniqueName, propertyPairs = entry.getValue());
            if (ResourceRegistrar.get(producer.getUniqueName()) != null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("resource already registered, skipping it:" + producer.getUniqueName());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("creating resource " + producer);
            }
            try {
                producer.init();
            }
            catch (ResourceConfigurationException ex) {
                log.warn("unable to create resource with unique name " + producer.getUniqueName(), (Throwable)ex);
                producer.close();
                ++errorCount;
            }
            this.resourcesByUniqueName.put(producer.getUniqueName(), producer);
        }
        return errorCount;
    }

    private Map<String, List<PropertyPair>> buildConfigurationEntriesMap(Properties properties) {
        HashMap<String, List<PropertyPair>> entries = new HashMap<String, List<PropertyPair>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ArrayList<PropertyPair> pairs;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("resource.")) continue;
            String[] keyParts = key.split("\\.");
            if (keyParts.length < 3) {
                log.warn("ignoring invalid entry in configuration file: " + key);
                continue;
            }
            String configuredName = keyParts[1];
            String propertyName = keyParts[2];
            if (keyParts.length > 3) {
                for (int i = 3; i < keyParts.length; ++i) {
                    propertyName = propertyName + "." + keyParts[i];
                }
            }
            if ((pairs = (ArrayList<PropertyPair>)entries.get(configuredName)) == null) {
                pairs = new ArrayList<PropertyPair>();
                entries.put(configuredName, pairs);
            }
            pairs.add(new PropertyPair(propertyName, value));
        }
        return entries;
    }

    private XAResourceProducer buildXAResourceProducer(String configuredName, List<PropertyPair> propertyPairs) throws ResourceConfigurationException {
        String lastPropertyName = "className";
        try {
            XAResourceProducer producer = this.createBean(configuredName, propertyPairs);
            for (PropertyPair propertyPair : propertyPairs) {
                lastPropertyName = propertyPair.getName();
                String propertyValue = propertyPair.getValue();
                PropertyUtils.setProperty(producer, lastPropertyName, propertyValue);
            }
            if (producer.getUniqueName() == null) {
                throw new ResourceConfigurationException("missing mandatory property [uniqueName] of resource [" + configuredName + "] in resources configuration file");
            }
            return producer;
        }
        catch (ResourceConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ResourceConfigurationException("cannot configure resource for configuration entries with name [" + configuredName + "]" + " - failing property is [" + lastPropertyName + "]", ex);
        }
    }

    private XAResourceProducer createBean(String configuredName, List<PropertyPair> propertyPairs) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        for (PropertyPair propertyPair : propertyPairs) {
            if (!propertyPair.getName().equals("className")) continue;
            String className = propertyPair.getValue();
            XAResourceProducer producer = ResourceLoader.instantiate(className);
            if (producer == null) {
                throw new ResourceConfigurationException("property [className] of resource [" + configuredName + "] in resources configuration file " + "must be the name of a class implementing either javax.sql.XADataSource or javax.jms.XAConnectionFactory");
            }
            return producer;
        }
        throw new ResourceConfigurationException("missing mandatory property [className] for resource [" + configuredName + "] in resources configuration file");
    }

    private final class PropertyPair {
        private final String name;
        private final String value;

        public PropertyPair(String key, String value) {
            this.name = key;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "/" + this.value;
        }
    }
}

