/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixHeuristicCommitException;
import bitronix.tm.internal.BitronixHeuristicMixedException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.twopc.AbstractPhaseEngine;
import bitronix.tm.twopc.PhaseException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rollbacker
extends AbstractPhaseEngine {
    private static final Logger log = LoggerFactory.getLogger(Rollbacker.class);
    private final List<XAResourceHolderState> interestedResources = Collections.synchronizedList(new ArrayList());
    private final List<XAResourceHolderState> rolledbackResources = Collections.synchronizedList(new ArrayList());

    public Rollbacker(Executor executor) {
        super(executor);
    }

    public void rollback(BitronixTransaction transaction, List<XAResourceHolderState> interestedResources) throws HeuristicMixedException, HeuristicCommitException, BitronixSystemException {
        XAResourceManager resourceManager = transaction.getResourceManager();
        transaction.setStatus(9);
        this.interestedResources.clear();
        this.interestedResources.addAll(interestedResources);
        try {
            this.executePhase(resourceManager, true);
        }
        catch (PhaseException ex) {
            this.logFailedResources(ex);
            transaction.setStatus(5);
            this.throwException("transaction failed during rollback of " + transaction, ex, interestedResources.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("rollback executed on resources " + Decoder.collectResourcesNames(this.rolledbackResources));
        }
        HashSet<String> rolledbackAndNotInterestedUniqueNames = new HashSet<String>();
        rolledbackAndNotInterestedUniqueNames.addAll(Rollbacker.collectResourcesUniqueNames(this.rolledbackResources));
        List<XAResourceHolderState> notInterestedResources = Rollbacker.collectNotInterestedResources(resourceManager.getAllResources(), interestedResources);
        rolledbackAndNotInterestedUniqueNames.addAll(Rollbacker.collectResourcesUniqueNames(notInterestedResources));
        if (log.isDebugEnabled()) {
            ArrayList<XAResourceHolderState> rolledbackAndNotInterestedResources = new ArrayList<XAResourceHolderState>();
            rolledbackAndNotInterestedResources.addAll(this.rolledbackResources);
            rolledbackAndNotInterestedResources.addAll(notInterestedResources);
            log.debug("rollback succeeded on resources " + Decoder.collectResourcesNames(rolledbackAndNotInterestedResources));
        }
        transaction.setStatus(4, rolledbackAndNotInterestedUniqueNames);
    }

    private void throwException(String message, PhaseException phaseException, int totalResourceCount) throws HeuristicMixedException, HeuristicCommitException {
        List<Exception> exceptions = phaseException.getExceptions();
        List<XAResourceHolderState> resources = phaseException.getResourceStates();
        boolean hazard = false;
        ArrayList<XAResourceHolderState> heuristicResources = new ArrayList<XAResourceHolderState>();
        ArrayList<XAResourceHolderState> errorResources = new ArrayList<XAResourceHolderState>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception ex = exceptions.get(i);
            XAResourceHolderState resourceHolder = resources.get(i);
            if (ex instanceof XAException) {
                XAException xaEx = (XAException)ex;
                switch (xaEx.errorCode) {
                    case 8: {
                        hazard = true;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        heuristicResources.add(resourceHolder);
                        break;
                    }
                    default: {
                        errorResources.add(resourceHolder);
                        break;
                    }
                }
                continue;
            }
            errorResources.add(resourceHolder);
        }
        if (!hazard && heuristicResources.size() == totalResourceCount) {
            throw new BitronixHeuristicCommitException(message + ":" + " all resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally committed", phaseException);
        }
        throw new BitronixHeuristicMixedException(message + ":" + (errorResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(errorResources) + " threw unexpected exception" : "") + (errorResources.size() > 0 && heuristicResources.size() > 0 ? " and" : "") + (heuristicResources.size() > 0 ? " resource(s) " + Decoder.collectResourcesNames(heuristicResources) + " improperly unilaterally committed" + (hazard ? " (or hazard happened)" : "") : ""), phaseException);
    }

    @Override
    protected Job createJob(XAResourceHolderState resourceHolder) {
        return new RollbackJob(resourceHolder);
    }

    @Override
    protected boolean isParticipating(XAResourceHolderState xaResourceHolderState) {
        for (XAResourceHolderState resourceHolderState : this.interestedResources) {
            if (xaResourceHolderState != resourceHolderState) continue;
            return true;
        }
        return false;
    }

    private final class RollbackJob
    extends Job {
        public RollbackJob(XAResourceHolderState resourceHolder) {
            super(resourceHolder);
        }

        @Override
        public void execute() {
            try {
                this.rollbackResource(this.getResource());
            }
            catch (RuntimeException ex) {
                this.runtimeException = ex;
            }
            catch (XAException ex) {
                this.xaException = ex;
            }
        }

        private void rollbackResource(XAResourceHolderState resourceHolder) throws XAException {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("trying to rollback resource " + resourceHolder);
                }
                resourceHolder.getXAResource().rollback(resourceHolder.getXid());
                Rollbacker.this.rolledbackResources.add(resourceHolder);
                if (log.isDebugEnabled()) {
                    log.debug("rolled back resource " + resourceHolder);
                }
            }
            catch (XAException ex) {
                this.handleXAException(resourceHolder, ex);
            }
        }

        private void handleXAException(XAResourceHolderState failedResourceHolder, XAException xaException) throws XAException {
            switch (xaException.errorCode) {
                case 6: {
                    this.forgetHeuristicRollback(failedResourceHolder);
                    return;
                }
                case 5: 
                case 7: 
                case 8: {
                    log.error("heuristic rollback is incompatible with the global state of this transaction - guilty: " + failedResourceHolder);
                    throw xaException;
                }
            }
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(xaException);
            log.warn("resource '" + failedResourceHolder.getUniqueName() + "' reported " + Decoder.decodeXAExceptionErrorCode(xaException) + " when asked to rollback transaction branch. Transaction is prepared and will rollback via recovery service when resource availability allows." + (extraErrorDetails == null ? "" : " Extra error=" + extraErrorDetails), (Throwable)xaException);
        }

        private void forgetHeuristicRollback(XAResourceHolderState resourceHolder) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("handling heuristic rollback on resource " + resourceHolder.getXAResource());
                }
                resourceHolder.getXAResource().forget(resourceHolder.getXid());
                if (log.isDebugEnabled()) {
                    log.debug("forgotten heuristically rolled back resource " + resourceHolder.getXAResource());
                }
            }
            catch (XAException ex) {
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.error("cannot forget " + resourceHolder.getXid() + " assigned to " + resourceHolder.getXAResource() + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), (Throwable)ex);
            }
        }

        public String toString() {
            return "a RollbackJob with " + this.getResource();
        }
    }
}

