/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixTransactionManagerObjectFactory;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.Version;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.internal.ThreadContext;
import bitronix.tm.internal.XAResourceManager;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import bitronix.tm.utils.Service;
import bitronix.tm.utils.Uid;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class BitronixTransactionManager
implements TransactionManager,
UserTransaction,
Referenceable,
Service {
    private static final Logger log = LoggerFactory.getLogger(BitronixTransactionManager.class);
    private static final String MDC_GTRID_KEY = "btm-gtrid";
    private final Map<Thread, ThreadContext> contexts = new ConcurrentHashMap<Thread, ThreadContext>(128, 0.75f, 128);
    private final Map<Uid, BitronixTransaction> inFlightTransactions = new ConcurrentHashMap<Uid, BitronixTransaction>(128, 0.75f, 128);
    private volatile boolean shuttingDown;

    public BitronixTransactionManager() {
        try {
            this.shuttingDown = false;
            this.logVersion();
            Configuration configuration = TransactionManagerServices.getConfiguration();
            configuration.buildServerIdArray();
            if (log.isDebugEnabled()) {
                log.debug("starting BitronixTransactionManager using " + String.valueOf(configuration));
            }
            TransactionManagerServices.getJournal().open();
            TransactionManagerServices.getResourceLoader().init();
            if (!configuration.isDisableRecovery()) {
                TransactionManagerServices.getRecoverer().run();
                int backgroundRecoveryInterval = TransactionManagerServices.getConfiguration().getBackgroundRecoveryIntervalSeconds();
                if (backgroundRecoveryInterval < 1) {
                    throw new InitializationException("invalid configuration value for backgroundRecoveryIntervalSeconds, found '" + backgroundRecoveryInterval + "' but it must be greater than 0");
                }
                if (log.isDebugEnabled()) {
                    log.debug("recovery will run in the background every " + backgroundRecoveryInterval + " second(s)");
                }
                Date nextExecutionDate = new Date(MonotonicClock.currentTimeMillis() + (long)backgroundRecoveryInterval * 1000L);
                TransactionManagerServices.getTaskScheduler().scheduleRecovery(TransactionManagerServices.getRecoverer(), nextExecutionDate);
            }
        }
        catch (IOException ex) {
            throw new InitializationException("cannot open disk journal", ex);
        }
        catch (Exception ex) {
            TransactionManagerServices.getJournal().shutdown();
            TransactionManagerServices.getResourceLoader().shutdown();
            throw new InitializationException("initialization failed, cannot safely start the transaction manager", ex);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug("beginning a new transaction");
        }
        if (this.isShuttingDown()) {
            throw new BitronixSystemException("cannot start a new transaction, transaction manager is shutting down");
        }
        this.dumpTransactionContexts();
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (currentTx != null) {
            throw new NotSupportedException("nested transactions not supported");
        }
        currentTx = this.createTransaction();
        ClearContextSynchronization clearContextSynchronization = new ClearContextSynchronization(currentTx);
        try {
            currentTx.getSynchronizationScheduler().add(clearContextSynchronization, Scheduler.ALWAYS_LAST_POSITION - 1);
            currentTx.setActive(this.getOrCreateCurrentContext().getTimeout());
            if (log.isDebugEnabled()) {
                log.debug("begun new transaction at " + String.valueOf(new Date(currentTx.getResourceManager().getGtrid().extractTimestamp())));
            }
        }
        catch (RuntimeException ex) {
            clearContextSynchronization.afterCompletion(6);
            throw ex;
        }
        catch (SystemException ex) {
            clearContextSynchronization.afterCompletion(6);
            throw ex;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("committing transaction " + String.valueOf(currentTx));
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("rolling back transaction " + String.valueOf(currentTx));
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.rollback();
    }

    public int getStatus() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (currentTx == null) {
            return 6;
        }
        return currentTx.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getCurrentTransaction();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("marking transaction as rollback only: " + String.valueOf(currentTx));
        }
        if (currentTx == null) {
            throw new IllegalStateException("no transaction started on this thread");
        }
        currentTx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new BitronixSystemException("cannot set a timeout to less than 0 second (was: " + seconds + "s)");
        }
        this.getOrCreateCurrentContext().setTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (log.isDebugEnabled()) {
            log.debug("suspending transaction " + String.valueOf(currentTx));
        }
        if (currentTx == null) {
            return null;
        }
        try {
            currentTx.getResourceManager().suspend();
            this.clearCurrentContextForSuspension();
            return currentTx;
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot suspend " + String.valueOf(currentTx) + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (log.isDebugEnabled()) {
            log.debug("resuming " + String.valueOf(transaction));
        }
        if (transaction == null) {
            throw new InvalidTransactionException("resumed transaction cannot be null");
        }
        if (!(transaction instanceof BitronixTransaction)) {
            throw new InvalidTransactionException("resumed transaction must be an instance of BitronixTransaction");
        }
        BitronixTransaction tx = (BitronixTransaction)transaction;
        BitronixTransaction currentTx = this.getCurrentTransaction();
        if (currentTx != null) {
            throw new IllegalStateException("a transaction is already running on this thread");
        }
        try {
            XAResourceManager resourceManager = tx.getResourceManager();
            resourceManager.resume();
            ThreadContext ctx = new ThreadContext();
            ctx.setTransaction(tx);
            this.setCurrentContext(ctx);
        }
        catch (XAException ex) {
            String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
            throw new BitronixSystemException("cannot resume " + String.valueOf(tx) + ", error=" + Decoder.decodeXAExceptionErrorCode(ex) + (String)(extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), ex);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BitronixTransactionManager.class.getName(), new StringRefAddr("TransactionManager", "BitronixTransactionManager"), BitronixTransactionManagerObjectFactory.class.getName(), null);
    }

    public Map getInFlightTransactions() {
        return this.inFlightTransactions;
    }

    public long getOldestInFlightTransactionTimestamp() {
        if (this.inFlightTransactions.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("oldest in-flight transaction's timestamp: -9223372036854775808");
            }
            return Long.MIN_VALUE;
        }
        long oldestTimestamp = Long.MAX_VALUE;
        for (Map.Entry<Uid, BitronixTransaction> entry : this.inFlightTransactions.entrySet()) {
            Uid gtrid = entry.getKey();
            long currentTimestamp = gtrid.extractTimestamp();
            if (currentTimestamp >= oldestTimestamp) continue;
            oldestTimestamp = currentTimestamp;
        }
        if (log.isDebugEnabled()) {
            log.debug("oldest in-flight transaction's timestamp: " + oldestTimestamp);
        }
        return oldestTimestamp;
    }

    public BitronixTransaction getCurrentTransaction() {
        if (this.contexts.get(Thread.currentThread()) == null) {
            return null;
        }
        return this.getOrCreateCurrentContext().getTransaction();
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void dumpTransactionContexts() {
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("dumping " + this.inFlightTransactions.size() + " transaction context(s)");
            }
            for (Map.Entry<Uid, BitronixTransaction> entry : this.inFlightTransactions.entrySet()) {
                BitronixTransaction tx = entry.getValue();
                if (!log.isDebugEnabled()) continue;
                log.debug(tx.toString());
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShuttingDown()) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction Manager has already shut down");
            }
            return;
        }
        log.info("shutting down Bitronix Transaction Manager");
        this.internalShutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down resource loader");
        }
        TransactionManagerServices.getResourceLoader().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down executor");
        }
        TransactionManagerServices.getExecutor().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down task scheduler");
        }
        TransactionManagerServices.getTaskScheduler().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down journal");
        }
        TransactionManagerServices.getJournal().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down recoverer");
        }
        TransactionManagerServices.getRecoverer().shutdown();
        if (log.isDebugEnabled()) {
            log.debug("shutting down configuration");
        }
        TransactionManagerServices.getConfiguration().shutdown();
        TransactionManagerServices.clear();
        if (log.isDebugEnabled()) {
            log.debug("shutdown ran successfully");
        }
    }

    private void internalShutdown() {
        this.shuttingDown = true;
        this.dumpTransactionContexts();
        int txCount = 0;
        try {
            txCount = this.inFlightTransactions.size();
            for (int seconds = TransactionManagerServices.getConfiguration().getGracefulShutdownInterval(); seconds > 0 && txCount > 0; --seconds) {
                if (log.isDebugEnabled()) {
                    log.debug("still " + txCount + " in-flight transactions, waiting... (" + seconds + " second(s) left)");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                txCount = this.inFlightTransactions.size();
            }
        }
        catch (Exception ex) {
            log.error("cannot get a list of in-flight transactions", (Throwable)ex);
        }
        if (txCount > 0) {
            if (log.isDebugEnabled()) {
                log.debug("still " + txCount + " in-flight transactions, shutting down anyway");
            }
            this.dumpTransactionContexts();
        } else if (log.isDebugEnabled()) {
            log.debug("all transactions finished, resuming shutdown");
        }
    }

    public String toString() {
        return "a BitronixTransactionManager with " + this.inFlightTransactions.size() + " in-flight transaction(s)";
    }

    private void logVersion() {
        log.info("Bitronix Transaction Manager version " + Version.getVersion());
        if (log.isDebugEnabled()) {
            log.debug("JVM version " + System.getProperty("java.version"));
        }
    }

    private BitronixTransaction createTransaction() {
        BitronixTransaction transaction = new BitronixTransaction();
        this.getOrCreateCurrentContext().setTransaction(transaction);
        this.inFlightTransactions.put(transaction.getResourceManager().getGtrid(), transaction);
        MDC.put((String)MDC_GTRID_KEY, (String)transaction.getGtrid());
        return transaction;
    }

    private void clearCurrentContextForSuspension() {
        if (log.isDebugEnabled()) {
            log.debug("clearing current thread context: " + String.valueOf(this.getOrCreateCurrentContext()));
        }
        this.contexts.remove(Thread.currentThread());
        if (log.isDebugEnabled()) {
            log.debug("cleared current thread context: " + String.valueOf(this.getOrCreateCurrentContext()));
        }
        MDC.remove((String)MDC_GTRID_KEY);
    }

    private void setCurrentContext(ThreadContext context) {
        if (log.isDebugEnabled()) {
            log.debug("changing current thread context to " + String.valueOf(context));
        }
        if (context == null) {
            throw new IllegalArgumentException("setCurrentContext() should not be called with a null context, clearCurrentContextForSuspension() should be used instead");
        }
        this.contexts.put(Thread.currentThread(), context);
        if (context.getTransaction() != null) {
            MDC.put((String)MDC_GTRID_KEY, (String)context.getTransaction().getGtrid());
        }
    }

    ThreadContext currentThreadContext() {
        return this.contexts.get(Thread.currentThread());
    }

    private ThreadContext getOrCreateCurrentContext() {
        ThreadContext threadContext = this.contexts.get(Thread.currentThread());
        if (threadContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("creating new thread context");
            }
            threadContext = new ThreadContext();
            this.setCurrentContext(threadContext);
        }
        return threadContext;
    }

    private class ClearContextSynchronization
    implements Synchronization {
        private final BitronixTransaction currentTx;

        public ClearContextSynchronization(BitronixTransaction currentTx) {
            this.currentTx = currentTx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            Iterator<Map.Entry<Thread, ThreadContext>> it = BitronixTransactionManager.this.contexts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Thread, ThreadContext> entry = it.next();
                ThreadContext context = entry.getValue();
                if (context.getTransaction() != this.currentTx) continue;
                if (log.isDebugEnabled()) {
                    log.debug("clearing thread context: " + String.valueOf(context));
                }
                it.remove();
                break;
            }
            BitronixTransactionManager.this.inFlightTransactions.remove(this.currentTx.getResourceManager().getGtrid());
            MDC.remove((String)BitronixTransactionManager.MDC_GTRID_KEY);
        }

        public String toString() {
            return "a ClearContextSynchronization for " + String.valueOf(this.currentTx);
        }
    }
}

