/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class MessageProducerWrapper
implements MessageProducer {
    private final MessageProducer messageProducer;
    protected final DualSessionWrapper session;
    private final PoolingConnectionFactory poolingConnectionFactory;

    public MessageProducerWrapper(MessageProducer messageProducer, DualSessionWrapper session, PoolingConnectionFactory poolingConnectionFactory) {
        this.messageProducer = messageProducer;
        this.session = session;
        this.poolingConnectionFactory = poolingConnectionFactory;
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    protected void enlistResource() throws JMSException {
        if (this.poolingConnectionFactory.getAutomaticEnlistingEnabled()) {
            this.session.getSession();
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this.session);
            }
            catch (SystemException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
            catch (RollbackException ex) {
                throw (JMSException)new JMSException("error enlisting " + String.valueOf(this)).initCause((Throwable)ex);
            }
        }
    }

    public String toString() {
        return "a MessageProducerWrapper of " + String.valueOf(this.session);
    }

    public void send(Message message) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    public void close() throws JMSException {
        this.getMessageProducer().close();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.getMessageProducer().setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.getMessageProducer().getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.getMessageProducer().setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.getMessageProducer().getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.getMessageProducer().setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.getMessageProducer().getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.getMessageProducer().setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.getMessageProducer().getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.getMessageProducer().setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.getMessageProducer().getTimeToLive();
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.getMessageProducer().setDeliveryDelay(deliveryDelay);
    }

    public long getDeliveryDelay() throws JMSException {
        return this.getMessageProducer().getDeliveryDelay();
    }

    public Destination getDestination() throws JMSException {
        return this.getMessageProducer().getDestination();
    }
}

