/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.BitronixTransactionSynchronizationRegistry;
import bitronix.tm.Configuration;
import bitronix.tm.journal.DiskJournal;
import bitronix.tm.journal.Journal;
import bitronix.tm.journal.NullJournal;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.ResourceLoader;
import bitronix.tm.timer.TaskScheduler;
import bitronix.tm.twopc.executor.AsyncExecutor;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.SyncExecutor;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.DefaultExceptionAnalyzer;
import bitronix.tm.utils.ExceptionAnalyzer;
import bitronix.tm.utils.InitializationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManagerServices {
    private static final Logger log = LoggerFactory.getLogger(TransactionManagerServices.class);
    private static final Lock transactionManagerLock = new ReentrantLock();
    private static volatile BitronixTransactionManager transactionManager;
    private static final AtomicReference<BitronixTransactionSynchronizationRegistry> transactionSynchronizationRegistryRef;
    private static final AtomicReference<Configuration> configurationRef;
    private static final AtomicReference<Journal> journalRef;
    private static final AtomicReference<TaskScheduler> taskSchedulerRef;
    private static final AtomicReference<ResourceLoader> resourceLoaderRef;
    private static final AtomicReference<Recoverer> recovererRef;
    private static final AtomicReference<Executor> executorRef;
    private static final AtomicReference<ExceptionAnalyzer> exceptionAnalyzerRef;

    public static BitronixTransactionManager getTransactionManager() {
        transactionManagerLock.lock();
        try {
            if (transactionManager == null) {
                transactionManager = new BitronixTransactionManager();
            }
            BitronixTransactionManager bitronixTransactionManager = transactionManager;
            return bitronixTransactionManager;
        }
        finally {
            transactionManagerLock.unlock();
        }
    }

    public static BitronixTransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        BitronixTransactionSynchronizationRegistry transactionSynchronizationRegistry = transactionSynchronizationRegistryRef.get();
        if (transactionSynchronizationRegistry == null && !transactionSynchronizationRegistryRef.compareAndSet(null, transactionSynchronizationRegistry = new BitronixTransactionSynchronizationRegistry())) {
            transactionSynchronizationRegistry = transactionSynchronizationRegistryRef.get();
        }
        return transactionSynchronizationRegistry;
    }

    public static Configuration getConfiguration() {
        Configuration configuration = configurationRef.get();
        if (configuration == null && !configurationRef.compareAndSet(null, configuration = new Configuration())) {
            configuration = configurationRef.get();
        }
        return configuration;
    }

    public static Journal getJournal() {
        Journal journal = journalRef.get();
        if (journal == null) {
            String configuredJournal = TransactionManagerServices.getConfiguration().getJournal();
            if ("null".equals(configuredJournal) || null == configuredJournal) {
                journal = new NullJournal();
            } else if ("disk".equals(configuredJournal)) {
                journal = new DiskJournal();
            } else {
                try {
                    Class clazz = ClassLoaderUtils.loadClass(configuredJournal);
                    journal = (Journal)clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new InitializationException("invalid journal implementation '" + configuredJournal + "'", ex);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("using journal " + configuredJournal);
            }
            if (!journalRef.compareAndSet(null, journal)) {
                journal = journalRef.get();
            }
        }
        return journal;
    }

    public static TaskScheduler getTaskScheduler() {
        TaskScheduler taskScheduler = taskSchedulerRef.get();
        if (taskScheduler == null) {
            taskScheduler = new TaskScheduler();
            if (!taskSchedulerRef.compareAndSet(null, taskScheduler)) {
                taskScheduler = taskSchedulerRef.get();
            } else {
                taskScheduler.start();
            }
        }
        return taskScheduler;
    }

    public static ResourceLoader getResourceLoader() {
        ResourceLoader resourceLoader = resourceLoaderRef.get();
        if (resourceLoader == null && !resourceLoaderRef.compareAndSet(null, resourceLoader = new ResourceLoader())) {
            resourceLoader = resourceLoaderRef.get();
        }
        return resourceLoader;
    }

    public static Recoverer getRecoverer() {
        Recoverer recoverer = recovererRef.get();
        if (recoverer == null && !recovererRef.compareAndSet(null, recoverer = new Recoverer())) {
            recoverer = recovererRef.get();
        }
        return recoverer;
    }

    public static Executor getExecutor() {
        Executor executor = executorRef.get();
        if (executor == null) {
            if (TransactionManagerServices.getConfiguration().isAsynchronous2Pc()) {
                if (log.isDebugEnabled()) {
                    log.debug("using AsyncExecutor");
                }
                executor = new AsyncExecutor();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("using SyncExecutor");
                }
                executor = new SyncExecutor();
            }
            if (!executorRef.compareAndSet(null, executor)) {
                executor.shutdown();
                executor = executorRef.get();
            }
        }
        return executor;
    }

    public static ExceptionAnalyzer getExceptionAnalyzer() {
        ExceptionAnalyzer analyzer = exceptionAnalyzerRef.get();
        if (analyzer == null) {
            String exceptionAnalyzerName = TransactionManagerServices.getConfiguration().getExceptionAnalyzer();
            analyzer = new DefaultExceptionAnalyzer();
            if (exceptionAnalyzerName != null) {
                try {
                    analyzer = (ExceptionAnalyzer)ClassLoaderUtils.loadClass(exceptionAnalyzerName).newInstance();
                }
                catch (Exception ex) {
                    log.warn("failed to initialize custom exception analyzer, using default one instead", (Throwable)ex);
                }
            }
            if (!exceptionAnalyzerRef.compareAndSet(null, analyzer)) {
                analyzer.shutdown();
                analyzer = exceptionAnalyzerRef.get();
            }
        }
        return analyzer;
    }

    public static boolean isTransactionManagerRunning() {
        return transactionManager != null;
    }

    public static boolean isTaskSchedulerRunning() {
        return taskSchedulerRef.get() != null;
    }

    protected static synchronized void clear() {
        transactionManager = null;
        transactionSynchronizationRegistryRef.set(null);
        configurationRef.set(null);
        journalRef.set(null);
        taskSchedulerRef.set(null);
        resourceLoaderRef.set(null);
        recovererRef.set(null);
        executorRef.set(null);
        exceptionAnalyzerRef.set(null);
    }

    static {
        transactionSynchronizationRegistryRef = new AtomicReference();
        configurationRef = new AtomicReference();
        journalRef = new AtomicReference();
        taskSchedulerRef = new AtomicReference();
        resourceLoaderRef = new AtomicReference();
        recovererRef = new AtomicReference();
        executorRef = new AtomicReference();
        exceptionAnalyzerRef = new AtomicReference();
    }
}

