package org.mule.certification.verifier;

import java.io.File;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
public class VerifiersFactory {

    public static Verifier existsAndNotEmpty(File file){
        return new ExistsAndNotEmptyCondition(file);
    }

    public static Verifier existsInPath(File file, String pattern, String description){
        return new ExistsInPathCondition(file, pattern)
                    .setPatternDescription(description);
    }

    public static Verifier hasContent(File file, List<String> expectedContent){
        return new HasExpectedContent(file, expectedContent);
    }
}
