package org.mule.certification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author Mulesoft, Inc
 */
public class Report {

    protected static final String PASSED = "Passed Validations";
    protected static final String FAILED = "Failed Validations";

    private Gson gson;

    private Map<String, List<String>> report = new HashMap<String, List<String>>(){{
        put(PASSED, new LinkedList<String>());
        put(FAILED, new LinkedList<String>());
    }};


    public Report(){
        gson = new GsonBuilder().setPrettyPrinting()
                                .disableHtmlEscaping()
                                .create();
    }

    public void passed(String msg){
        if (!StringUtils.isEmpty(msg)) {
            report.get(PASSED).add(msg);
        }
    }

    public void failed(String msg){
        if (!StringUtils.isEmpty(msg)) {
            report.get(FAILED).add(msg);
        }
    }

    public String export(){

        return gson.toJson(report, Map.class);
    }


}
