/*
 * Decompiled with CFR 0.152.
 */
package org.mule.certification;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.certification.Report;
import org.mule.certification.verifier.Verifier;
import org.mule.certification.verifier.VerifiersFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="validate")
@Execute(goal="validate")
public class StructureMojo
extends AbstractMojo {
    public static final String CLOSED_HEADER_MODEL = "closedHeader.txt";
    public static final String OPEN_HEADER_MODEL = "openHeader.txt";
    public static final String CLOSED_LICENSE_MODEL = "closedLicense.txt";
    public static final String OPEN_LICENSE_MODEL = "openLicense.txt";
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected File basedir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File target;
    @Parameter(property="closedProject", defaultValue="false", readonly=true)
    private Boolean closedProject;
    @Parameter(property="checkLicenseContent", defaultValue="false", readonly=true)
    private Boolean checkLicenseContent;
    private Report report;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
        HashMap<RequiredKey, File> requiredResources = new HashMap<RequiredKey, File>(){
            {
                this.put(RequiredKey.DOC, StructureMojo.this.getRelativeFile("doc"));
                this.put(RequiredKey.DEMO, StructureMojo.this.getRelativeFile("demo"));
                this.put(RequiredKey.ICONS, StructureMojo.this.getRelativeFile("icons"));
                this.put(RequiredKey.MAIN, StructureMojo.this.getRelativeFile("src/main/java"));
                this.put(RequiredKey.TEST, StructureMojo.this.getRelativeFile("src/test/java"));
                this.put(RequiredKey.README_MD, StructureMojo.this.getRelativeFile("README.md"));
                this.put(RequiredKey.LICENSE_MD, StructureMojo.this.getRelativeFile("LICENSE.md"));
                this.put(RequiredKey.HEADER, StructureMojo.this.getRelativeFile("LICENSE_HEADER.txt"));
            }
        };
        List<Verifier> verifiers = this.setupVerifiers((Map<RequiredKey, File>)requiredResources);
        boolean failed = this.runVerifiers(verifiers);
        this.report.exportToFile();
        if (failed) {
            throw new MojoFailureException(String.format("Failed to verify some rules, please check the full results in %s", this.report.getFinalReportPath()));
        }
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        this.getLog().info((CharSequence)"All Project structure validations passed!");
        this.getLog().info((CharSequence)String.format("For further details check the full results in %s", this.report.getFinalReportPath()));
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    File getRelativeFile(String relativePath) {
        return new File(this.basedir, relativePath);
    }

    private boolean runVerifiers(List<Verifier> verifiers) {
        boolean failed = false;
        for (Verifier v : verifiers) {
            try {
                if (!v.verify().booleanValue()) {
                    this.logFailure(v);
                    failed = true;
                    continue;
                }
                this.logSuccess(v);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)e.getMessage());
                this.logFailure(v);
            }
        }
        return failed;
    }

    private List<Verifier> setupVerifiers(Map<RequiredKey, File> requiredResources) {
        LinkedList<Verifier> verifiers = new LinkedList<Verifier>();
        for (File required : requiredResources.values()) {
            verifiers.add(VerifiersFactory.existsAndNotEmpty(required));
        }
        verifiers.add(VerifiersFactory.existsInPath(requiredResources.get((Object)RequiredKey.DOC), ".+\\.md", "ending with '.md'"));
        verifiers.add(VerifiersFactory.existsInPath(requiredResources.get((Object)RequiredKey.ICONS), ".*24x16\\.png", "ending with '24x16.png'"));
        verifiers.add(VerifiersFactory.existsInPath(requiredResources.get((Object)RequiredKey.ICONS), ".*48x32\\.png", "ending with '48x32.png'"));
        verifiers.add(VerifiersFactory.existsInPath(requiredResources.get((Object)RequiredKey.MAIN), ".+Connector.java", "ending with 'Connector.java'"));
        if (this.checkLicenseContent.booleanValue()) {
            verifiers.add(VerifiersFactory.hasContent(requiredResources.get((Object)RequiredKey.LICENSE_MD), this.getLicenseContent()));
            verifiers.add(VerifiersFactory.hasContent(requiredResources.get((Object)RequiredKey.HEADER), this.getHeaderContent()));
        }
        return verifiers;
    }

    private void logSuccess(Verifier v) {
        this.getLog().debug((CharSequence)("Verified rule :: " + v.ruleMessage()));
        this.report.passed(v.ruleMessage());
    }

    private void logFailure(Verifier v) {
        this.getLog().error((CharSequence)("Failed to verify rule :: " + v.ruleMessage()));
        this.report.failed(v.ruleMessage());
    }

    private List<String> getHeaderContent() {
        try {
            String name = this.closedProject != false ? CLOSED_HEADER_MODEL : OPEN_HEADER_MODEL;
            return IOUtils.readLines((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private List<String> getLicenseContent() {
        try {
            String name = this.closedProject != false ? CLOSED_LICENSE_MODEL : OPEN_LICENSE_MODEL;
            return IOUtils.readLines((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private void setLogLevel() {
        if (this.getLog().isDebugEnabled()) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    private void initialize() {
        this.report = new Report(this.target);
        this.setLogLevel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequiredKey {
        DOC,
        DEMO,
        ICONS,
        MAIN,
        TEST,
        HEADER,
        LICENSE_MD,
        README_MD;

    }
}

