package org.mule.certification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author Mulesoft, Inc
 */
public class Report {

    public static final String REPORT_DIR = "reports";
    public static final String REPORT_FILE = "certificationReport.json";

    protected static final String PASSED = "Passed Validations";
    protected static final String FAILED = "Failed Validations";

    private final Logger logger = LogManager.getRootLogger();

    private final File target;
    private Gson gson;

    private Map<String, List<String>> report = new HashMap<String, List<String>>(){{
        put(PASSED, new LinkedList<String>());
        put(FAILED, new LinkedList<String>());
    }};


    public Report(File targetDirectory){
        target = targetDirectory;
        gson = new GsonBuilder().setPrettyPrinting()
                                .disableHtmlEscaping()
                                .create();
    }

    public void passed(String msg){
        if (!StringUtils.isEmpty(msg)) {
            report.get(PASSED).add(msg);
        }
    }

    public void failed(String msg){
        if (!StringUtils.isEmpty(msg)) {
            report.get(FAILED).add(msg);
        }
    }

    public String getAsJson(){

        return gson.toJson(report, Map.class);
    }

    public String getFinalReportPath(){
        return String.format("%s/%s/%s", target.getPath(), REPORT_DIR, REPORT_FILE);
    }

    public void exportToFile() {
        try {
            File destination = new File(target, REPORT_DIR);
            FileUtils.forceMkdir(destination);
            FileUtils.write(new File(destination, REPORT_FILE), getAsJson());

        } catch (IOException e) {
            logger.error("Unable to export results to " + getFinalReportPath());
            logger.error(e.getMessage());
        }
    }


}
