package org.mule.certification.verifier;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;

/**
 * @author Mulesoft, Inc
 */
public class ExistsInPathCondition implements Verifier {

    private File root;
    private String requiredPattern;
    private String description;

    public ExistsInPathCondition(File root, String pattern){
        this.root = root;
        this.requiredPattern = pattern;
        this.description = pattern;
    }

    @Override
    public Boolean verify() throws IOException {
       return dirContainsFile(root);
    }

    @Override
    public String ruleMessage() {
        return "File " + description + " exists and is not empty under path " + root.getPath();
    }

    public ExistsInPathCondition setPatternDescription(String description){
        if (!StringUtils.isEmpty(description)){
            this.description = description;
        }
        return this;
    }

    private Boolean dirContainsFile(File dir){

        if (dir == null || dir.isHidden())
            return false;

        File[] contents = dir.listFiles();
        if (contents == null)
            return false;

        boolean contained = false;
        for (File file: contents){
            if (file.isDirectory()){
                contained = dirContainsFile(file);
            } else {
                if ( Pattern.matches(requiredPattern, file.getName()) && !FileUtils.sizeOfAsBigInteger(file).equals(BigInteger.ZERO)){
                    contained = true;
                }
            }

            if (contained) break;
        }

        return contained;
    }
}
