/*
 * Decompiled with CFR 0.152.
 */
package org.mule.certification;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Report {
    public static final String REPORT_DIR = "reports";
    public static final String REPORT_FILE = "certificationReport.json";
    protected static final String PASSED = "Passed Validations";
    protected static final String FAILED = "Failed Validations";
    private final Logger logger = LogManager.getRootLogger();
    private final File target;
    private Gson gson;
    private Map<String, List<String>> report = new HashMap<String, List<String>>(){
        {
            this.put(Report.PASSED, new LinkedList());
            this.put(Report.FAILED, new LinkedList());
        }
    };

    public Report(File targetDirectory) {
        this.target = targetDirectory;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public void passed(String msg) {
        if (!StringUtils.isEmpty((String)msg)) {
            this.report.get(PASSED).add(msg);
        }
    }

    public void failed(String msg) {
        if (!StringUtils.isEmpty((String)msg)) {
            this.report.get(FAILED).add(msg);
        }
    }

    public String getAsJson() {
        return this.gson.toJson(this.report, Map.class);
    }

    public String getFinalReportPath() {
        return String.format("%s/%s/%s", this.target.getPath(), REPORT_DIR, REPORT_FILE);
    }

    public void exportToFile() {
        try {
            File destination = new File(this.target, REPORT_DIR);
            FileUtils.forceMkdir((File)destination);
            FileUtils.write((File)new File(destination, REPORT_FILE), (CharSequence)this.getAsJson());
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to export results to " + this.getFinalReportPath()));
            this.logger.error((Object)e.getMessage());
        }
    }
}

