package org.mule.certification.verifier;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;

/**
 * @author Mulesoft, Inc
 */
public class ExistsAndNotEmptyCondition implements Verifier {

    private File required;

    public ExistsAndNotEmptyCondition(File file){
        this.required = file;
    }

    @Override
    public Boolean verify() throws IOException {
        return required.exists() && !emptyFile(required);
    }

    @Override
    public String ruleMessage() {
        return "File " + required.getAbsolutePath() + " exists and is not empty";
    }

    private Boolean emptyFile(File file) throws IOException {

        if (file.isDirectory()){
            return FileUtils.sizeOfDirectoryAsBigInteger(file).equals(BigInteger.ZERO);
        } else {
            return FileUtils.sizeOfAsBigInteger(file).equals(BigInteger.ZERO);
        }
    }
}
