package org.mule.certification.verifier;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
public class HasExpectedContent implements Verifier {

    private Logger logger = Logger.getLogger(this.getClass());
    private File tested = null;
    private List<String> expected = null;


    public HasExpectedContent(File tested, List<String> expected){
        this.tested = tested;
        this.expected = expected;
    }

    @Override
    public Boolean verify() throws IOException {
        return inspectedFileHasExpectedContent();
    }

    private Boolean inspectedFileHasExpectedContent() {
        try {
            return FileUtils.readLines(tested).containsAll(expected);
        } catch (IOException e) {
            logger.debug(e.getMessage());
        }

        return false;
    }

    @Override
    public String ruleMessage() {
        return "Content of file " + tested.toString() + " matches the expected for certification";
    }
}
