package org.mule.certification.verifier;

import org.apache.commons.lang.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
class OrVerifier implements Verifier {

    private final Verifier[] verifiers;

    OrVerifier(Verifier... verifiers) {
        this.verifiers = verifiers;
    }

    @Override
    public Boolean verify() throws IOException {
        for (Verifier verifier : verifiers) {
            if(verifier.verify()){
              return true;
            }
        }
        return false;
    }

    @Override
    public String ruleMessage() {
        List<String> stringList = new ArrayList<String>();

        for (Verifier verifier : verifiers) {
            stringList.add(verifier.ruleMessage());
        }

        return StringUtils.join(stringList, " or ");
    }
}
