/*
 * Decompiled with CFR 0.152.
 */
package org.mule.certification.verifier;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.io.FileUtils;
import org.mule.certification.verifier.Verifier;

public class ExistsAndNotEmptyCondition
implements Verifier {
    private File required;

    public ExistsAndNotEmptyCondition(File file) {
        this.required = file;
    }

    @Override
    public Boolean verify() throws IOException {
        return this.required.exists() && this.emptyFile(this.required) == false;
    }

    @Override
    public String ruleMessage() {
        return "File " + this.required.getAbsolutePath() + " exists and is not empty";
    }

    private Boolean emptyFile(File file) throws IOException {
        if (file.isDirectory()) {
            return FileUtils.sizeOfDirectoryAsBigInteger((File)file).equals(BigInteger.ZERO);
        }
        return FileUtils.sizeOfAsBigInteger((File)file).equals(BigInteger.ZERO);
    }
}

