/*
 * Decompiled with CFR 0.152.
 */
package org.mule.certification.verifier;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.certification.verifier.Verifier;

public class ExistsInPathCondition
implements Verifier {
    private File root;
    private String requiredPattern;
    private String description;

    public ExistsInPathCondition(File root, String pattern) {
        this.root = root;
        this.requiredPattern = pattern;
        this.description = pattern;
    }

    @Override
    public Boolean verify() throws IOException {
        return this.dirContainsFile(this.root);
    }

    @Override
    public String ruleMessage() {
        return "File " + this.description + " exists and is not empty under path " + this.root.getPath();
    }

    public ExistsInPathCondition setPatternDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            this.description = description;
        }
        return this;
    }

    private Boolean dirContainsFile(File dir) {
        if (dir == null || dir.isHidden()) {
            return false;
        }
        File[] contents = dir.listFiles();
        if (contents == null) {
            return false;
        }
        boolean contained = false;
        for (File file : contents) {
            if (file.isDirectory()) {
                contained = this.dirContainsFile(file);
            } else if (Pattern.matches(this.requiredPattern, file.getName()) && !FileUtils.sizeOfAsBigInteger((File)file).equals(BigInteger.ZERO)) {
                contained = true;
            }
            if (contained) break;
        }
        return contained;
    }
}

