/*
 * Decompiled with CFR 0.152.
 */
package org.mule.certification.verifier;

import java.io.File;
import java.util.List;
import org.mule.certification.verifier.ExistsAndNotEmptyCondition;
import org.mule.certification.verifier.ExistsInPathCondition;
import org.mule.certification.verifier.HasExpectedContent;
import org.mule.certification.verifier.OrVerifier;
import org.mule.certification.verifier.Verifier;

public class VerifiersFactory {
    public static Verifier existsAndNotEmpty(File file) {
        return new ExistsAndNotEmptyCondition(file);
    }

    public static Verifier existsInPath(File file, String pattern, String description) {
        return new ExistsInPathCondition(file, pattern).setPatternDescription(description);
    }

    public static Verifier or(Verifier ... verifiers) {
        return new OrVerifier(verifiers);
    }

    public static Verifier hasContent(File file, List<String> expectedContent) {
        return new HasExpectedContent(file, expectedContent);
    }
}

