/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.DefaultUnknownMetaDataModel;
import org.mule.common.metadata.JSONMetadataModelFactoryHelper;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataFieldFactory;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.JSONTypeUtils;

public class JSONSchemaMetaDataFieldFactory
implements MetaDataFieldFactory {
    private final JSONMetadataModelFactoryHelper helper;
    private JSONType jsonSchemaType;

    public JSONSchemaMetaDataFieldFactory(JSONObjectType type) {
        this(type, new JSONMetadataModelFactoryHelper());
    }

    public JSONSchemaMetaDataFieldFactory(JSONObjectType type, Map<JSONObjectType, DefaultStructuredMetadataModel> visitedTypes) {
        this(type, new JSONMetadataModelFactoryHelper(visitedTypes));
    }

    public JSONSchemaMetaDataFieldFactory(JSONObjectType type, JSONMetadataModelFactoryHelper helper) {
        this.jsonSchemaType = type;
        this.helper = helper;
    }

    @Override
    public List<MetaDataField> createFields() {
        ArrayList<MetaDataField> metaDataFields = new ArrayList<MetaDataField>();
        this.loadFields((JSONObjectType)this.jsonSchemaType, metaDataFields);
        return metaDataFields;
    }

    private void processJSONSchemaElement(JSONType property, String name, List<MetaDataField> metadata) {
        if (property.isJSONObject()) {
            this.processJSONSchemaObject((JSONObjectType)property, name, metadata);
        } else if (property.isJSONPrimitive()) {
            this.processJSONSchemaPrimitive(property, name, metadata);
        } else if (property.isJSONArray()) {
            this.processJSONSchemaArray((JSONArrayType)property, name, metadata);
        } else if (property.isJSONPointer()) {
            this.processJSONPointer((JSONPointerType)property, name, metadata);
        }
    }

    private void processJSONSchemaObject(JSONObjectType type, String name, List<MetaDataField> metadata) {
        DefaultStructuredMetadataModel model = this.helper.buildJSONMetaDataModel(type);
        metadata.add(new DefaultMetaDataField(name, model));
    }

    private void loadFields(JSONObjectType type, List<MetaDataField> metadata) {
        String[] properties;
        for (String key : properties = type.getProperties()) {
            JSONType propertyType = type.getPropertyType(key);
            this.processJSONSchemaElement(propertyType, key, metadata);
        }
    }

    private void processJSONSchemaArray(JSONArrayType property, String name, List<MetaDataField> metadata) {
        AbstractMetaDataModel model = this.helper.buildJSONArrayMetaDataModel(property);
        metadata.add(new DefaultMetaDataField(name, new DefaultListMetaDataModel(model)));
    }

    private void processJSONSchemaPrimitive(JSONType property, String name, List<MetaDataField> metadata) {
        DataType dataType = JSONTypeUtils.getDataType(property);
        AbstractMetaDataModel model = dataType == DataType.UNKNOWN ? new DefaultUnknownMetaDataModel() : new DefaultSimpleMetaDataModel(dataType);
        metadata.add(new DefaultMetaDataField(name, model));
    }

    private void processJSONPointer(JSONPointerType ptr, String name, List<MetaDataField> metadata) {
        this.processJSONSchemaElement(ptr.resolve(), name, metadata);
    }
}

