/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.bulk;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.common.bulk.AbstractBulkBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BulkItem<T>
implements Serializable {
    private static final long serialVersionUID = -2402370691833265593L;
    private final Serializable id;
    private final boolean successful;
    private final String message;
    private final String statusCode;
    private final Exception exception;
    private final T payload;
    private final Map<String, Serializable> customProperties;

    private BulkItem(Serializable id, boolean successful, String message, String statusCode, Exception exception, T payload, Map<String, Serializable> customProperties) {
        this.id = id;
        this.successful = successful;
        this.message = message;
        this.statusCode = statusCode;
        this.exception = exception;
        this.payload = payload;
        this.customProperties = customProperties != null ? new HashMap<String, Serializable>(customProperties) : null;
    }

    public Serializable getId() {
        return this.id;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Exception getException() {
        return this.exception;
    }

    public T getPayload() {
        return this.payload;
    }

    public Serializable getCustomProperty(String key) {
        return this.customProperties != null ? this.customProperties.get(key) : null;
    }

    public static <T> BulkItemBuilder<T> builder() {
        return new BulkItemBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BulkItemBuilder<T>
    extends AbstractBulkBuilder {
        private Serializable id;
        private boolean successful = true;
        private String message;
        private String statusCode;
        private Exception exception;
        private T payload;

        public BulkItemBuilder<T> setRecordId(Serializable recordId) {
            this.id = recordId;
            return this;
        }

        public BulkItemBuilder<T> setSuccessful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public BulkItemBuilder<T> setMessage(String message) {
            this.message = message;
            return this;
        }

        public BulkItemBuilder<T> setStatusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public BulkItemBuilder<T> setException(Exception exception) {
            this.exception = exception;
            this.successful = false;
            return this;
        }

        public BulkItemBuilder<T> setPayload(T payload) {
            this.payload = payload;
            return this;
        }

        public BulkItemBuilder<T> addCustomProperty(String key, Serializable value) {
            this.customProperty(key, value);
            return this;
        }

        protected BulkItem<T> build() {
            return new BulkItem(this.id, this.successful, this.message, this.statusCode, this.exception, this.payload, this.getCustomProperties());
        }
    }
}

