/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.bulk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.bulk.AbstractBulkBuilder;
import org.mule.common.bulk.BulkItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BulkOperationResult<T>
implements Serializable {
    private static final long serialVersionUID = 8039267004891928585L;
    private final Serializable id;
    private final boolean successful;
    private final List<BulkItem<T>> items;
    private final Map<String, Serializable> customProperties;

    private BulkOperationResult(Serializable id, boolean successful, List<BulkItem<T>> items, Map<String, Serializable> customProperties) {
        this.id = id;
        this.successful = successful;
        this.items = items;
        this.customProperties = customProperties != null ? new HashMap<String, Serializable>(customProperties) : null;
    }

    public Serializable getId() {
        return this.id;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<BulkItem<T>> getItems() {
        return this.items;
    }

    public Serializable getCustomProperty(String key) {
        return this.customProperties != null ? this.customProperties.get(key) : null;
    }

    public static <T> BulkOperationResultBuilder<T> builder() {
        return new BulkOperationResultBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BulkOperationResultBuilder<T>
    extends AbstractBulkBuilder {
        private Serializable id;
        private boolean successful = true;
        private List<BulkItem.BulkItemBuilder<T>> items = new ArrayList<BulkItem.BulkItemBuilder<T>>();

        private BulkOperationResultBuilder() {
        }

        public BulkOperationResultBuilder<T> setSuccessful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public BulkOperationResultBuilder<T> setId(Serializable id) {
            this.id = id;
            return this;
        }

        public BulkOperationResultBuilder<T> addItem(BulkItem.BulkItemBuilder<T> recordResultBuilder) {
            this.items.add(recordResultBuilder);
            return this;
        }

        public BulkOperationResultBuilder<T> addCustomProperty(String key, Serializable value) {
            this.customProperty(key, value);
            return this;
        }

        public BulkOperationResult<T> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("A BulkOperationResult must have at least one BulkItem. Please add a result an try again");
            }
            ArrayList<BulkItem<T>> items = new ArrayList<BulkItem<T>>(this.items.size());
            for (BulkItem.BulkItemBuilder<T> recordBuilder : this.items) {
                BulkItem<T> record = recordBuilder.build();
                items.add(record);
                if (record.isSuccessful()) continue;
                this.successful = false;
            }
            return new BulkOperationResult(this.id, this.successful, items, this.getCustomProperties());
        }
    }
}

