/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.MetaDataModelVisitor;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.datatype.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlMetaDataModel
extends AbstractMetaDataModel
implements XmlMetaDataModel {
    private List<String> schemas;
    private String rootElement;
    private Charset encoding;
    private String example;

    public DefaultXmlMetaDataModel(List<String> schemas, String rootElement, Charset encoding) {
        super(DataType.XML);
        this.schemas = schemas;
        this.rootElement = rootElement;
        this.encoding = encoding;
    }

    @Override
    public String getRootElement() {
        return this.rootElement;
    }

    @Override
    public List<InputStream> getSchemas() {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (String schema : this.schemas) {
            result.add(new ByteArrayInputStream(schema.getBytes(this.encoding)));
        }
        return result;
    }

    @Override
    public void accept(MetaDataModelVisitor modelVisitor) {
        modelVisitor.visitXmlMetaDataModel(this);
    }

    @Override
    public String getExample() {
        return this.example;
    }

    @Override
    public void setExample(String xmlExample) {
        this.example = xmlExample;
    }
}

