/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.builder;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.builder.AddingOperatorsMetaDataFieldBuilder;
import org.mule.common.metadata.builder.CustomizingWhereMetaDataFieldBuilder;
import org.mule.common.metadata.builder.DefaultListMetaDataBuilder;
import org.mule.common.metadata.builder.DefaultMetaDataFieldBuilder;
import org.mule.common.metadata.builder.DefaultPojoMetaDataBuilder;
import org.mule.common.metadata.builder.DefaultSimpleMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.builder.EnumMetaDataBuilder;
import org.mule.common.metadata.builder.ListMetaDataBuilder;
import org.mule.common.metadata.builder.MetaDataBuilder;
import org.mule.common.metadata.builder.PropertyCustomizableMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDynamicObjectBuilder<P extends MetaDataBuilder<?>>
implements EnumMetaDataBuilder<P> {
    private String name;
    private List<DefaultMetaDataFieldBuilder> fields;
    private P parentBuilder;

    DefaultDynamicObjectBuilder(String name, P parentBuilder) {
        this.name = name;
        this.parentBuilder = parentBuilder;
        this.fields = new ArrayList<DefaultMetaDataFieldBuilder>();
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> addSimpleField(String name, DataType dataType) {
        this.fields.add(new DefaultMetaDataFieldBuilder(name, new DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder>(dataType, this)));
        return this;
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> addSimpleField(String name, DataType dataType, String implClass) {
        DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder> builder = new DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder>(dataType, this);
        builder.setImplClass(implClass);
        this.fields.add(new DefaultMetaDataFieldBuilder(name, builder));
        return this;
    }

    @Override
    public DynamicObjectFieldBuilder<P> addPojoField(String name, Class<?> pojo) {
        this.fields.add(new DefaultMetaDataFieldBuilder(name, new DefaultPojoMetaDataBuilder<DefaultDynamicObjectBuilder>(pojo, this)));
        return this;
    }

    @Override
    public DynamicObjectFieldBuilder<DynamicObjectFieldBuilder<P>> addListOfDynamicObjectField(String name) {
        DefaultListMetaDataBuilder<DefaultDynamicObjectBuilder> builder = new DefaultListMetaDataBuilder<DefaultDynamicObjectBuilder>(this);
        DefaultDynamicObjectBuilder dynamicObjectBuilder = (DefaultDynamicObjectBuilder)builder.ofDynamicObject(name);
        this.fields.add(new DefaultMetaDataFieldBuilder(name, builder));
        dynamicObjectBuilder.parentBuilder = this;
        return dynamicObjectBuilder;
    }

    @Override
    public ListMetaDataBuilder<DynamicObjectFieldBuilder<P>> addList(String name) {
        DefaultListMetaDataBuilder<DynamicObjectFieldBuilder<P>> builder = new DefaultListMetaDataBuilder<DynamicObjectFieldBuilder<P>>(this);
        this.fields.add(new DefaultMetaDataFieldBuilder(name, builder));
        return builder;
    }

    @Override
    public DynamicObjectFieldBuilder<DynamicObjectFieldBuilder<P>> addDynamicObjectField(String name) {
        DefaultDynamicObjectBuilder<DynamicObjectFieldBuilder<P>> builder = new DefaultDynamicObjectBuilder<DynamicObjectFieldBuilder<P>>(name, this);
        this.fields.add(new DefaultMetaDataFieldBuilder(name, builder));
        return builder;
    }

    @Override
    public P endDynamicObject() {
        return this.parentBuilder;
    }

    @Override
    public DefinedMapMetaDataModel build() {
        ArrayList<MetaDataField> fieldList = new ArrayList<MetaDataField>();
        for (DefaultMetaDataFieldBuilder field : this.fields) {
            fieldList.add(field.build());
        }
        return new DefaultDefinedMapMetaDataModel(fieldList, this.name);
    }

    private DefaultMetaDataFieldBuilder getCurrentField() {
        return this.fields.get(this.fields.size() - 1);
    }

    @Override
    public DynamicObjectFieldBuilder<P> withAccessType(MetaDataField.FieldAccessType accessType) {
        this.getCurrentField().withAccessType(accessType);
        return this;
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> isSelectCapable(boolean capable) {
        this.getCurrentField().isSelectCapable(capable);
        return this;
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> isOrderByCapable(boolean capable) {
        this.getCurrentField().isOrderByCapable(capable);
        return this;
    }

    @Override
    public CustomizingWhereMetaDataFieldBuilder<P> isWhereCapable(boolean capable) {
        this.getCurrentField().isWhereCapable(capable);
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> withSpecificOperations() {
        return this;
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> withDefaultOperations() {
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsEquals() {
        this.getCurrentField().supportsEquals();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsNotEquals() {
        this.getCurrentField().supportsNotEquals();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsGreater() {
        this.getCurrentField().supportsGreater();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsGreaterOrEquals() {
        this.getCurrentField().supportsGreaterOrEquals();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsLess() {
        this.getCurrentField().supportsLess();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsLessOrEquals() {
        this.getCurrentField().supportsLessOrEquals();
        return this;
    }

    @Override
    public AddingOperatorsMetaDataFieldBuilder<P> supportsLike() {
        this.getCurrentField().supportsLike();
        return this;
    }

    @Override
    public EnumMetaDataBuilder<P> setValues(String ... strings) {
        this.getCurrentField().setEnumValues(strings);
        return this;
    }

    @Override
    public EnumMetaDataBuilder<P> addEnumField(String name) {
        this.fields.add(new DefaultMetaDataFieldBuilder(name, new DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder>(DataType.ENUM, this)));
        return this;
    }

    @Override
    public EnumMetaDataBuilder<P> addEnumField(String name, String implClass) {
        DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder> builder = new DefaultSimpleMetaDataBuilder<DefaultDynamicObjectBuilder>(DataType.ENUM, this);
        builder.setImplClass(implClass);
        this.fields.add(new DefaultMetaDataFieldBuilder(name, builder));
        return this;
    }

    @Override
    public PropertyCustomizableMetaDataBuilder<P> setExample(String example) {
        this.getCurrentField().setExample(example);
        return this;
    }

    @Override
    public EnumMetaDataBuilder<P> setValues(List<String> values) {
        this.getCurrentField().setEnumValues(values.toArray(new String[values.size()]));
        return this;
    }
}

