/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.field.property;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.SupportedOperatorsFactory;
import org.mule.common.metadata.field.property.FieldPropertyFactory;
import org.mule.common.metadata.field.property.MetaDataFieldProperty;
import org.mule.common.metadata.field.property.ValidStringValuesFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlOrderMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlQueryOperatorsMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlSelectMetaDataFieldProperty;
import org.mule.common.metadata.field.property.dsql.DsqlWhereMetaDataFieldProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFieldPropertyFactory
implements FieldPropertyFactory {
    @Override
    public List<MetaDataFieldProperty> getProperties(String name, MetaDataModel metaDataModel) {
        ArrayList<MetaDataFieldProperty> fieldProperties = new ArrayList<MetaDataFieldProperty>();
        fieldProperties.add(new DsqlSelectMetaDataFieldProperty());
        fieldProperties.add(new DsqlWhereMetaDataFieldProperty());
        fieldProperties.add(new DsqlOrderMetaDataFieldProperty());
        fieldProperties.add(new DsqlQueryOperatorsMetaDataFieldProperty(SupportedOperatorsFactory.getInstance().getSupportedOperationsFor(metaDataModel.getDataType())));
        return fieldProperties;
    }

    @Override
    public List<MetaDataFieldProperty> getProperties(Class<?> clazz) {
        ArrayList<MetaDataFieldProperty> fieldProperties = new ArrayList<MetaDataFieldProperty>();
        if (clazz.isEnum()) {
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Enum e : (Enum[])clazz.getEnumConstants()) {
                enumValues.add(e.name());
            }
            fieldProperties.add(new ValidStringValuesFieldProperty(enumValues.toArray(new String[enumValues.size()])));
        }
        return fieldProperties;
    }
}

