/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.List;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataFieldFactory;
import org.mule.common.metadata.MetaDataModelVisitor;
import org.mule.common.metadata.StructuredMetaDataModel;
import org.mule.common.metadata.datatype.DataType;

public class DefaultStructuredMetadataModel
extends AbstractMetaDataModel
implements StructuredMetaDataModel {
    private List<MetaDataField> fields;

    public DefaultStructuredMetadataModel(DataType dataType) {
        super(dataType);
    }

    public DefaultStructuredMetadataModel(DataType dataType, MetaDataFieldFactory fieldFactory) {
        this(dataType);
        this.loadFieldsFrom(fieldFactory);
    }

    public void loadFieldsFrom(MetaDataFieldFactory fieldFactory) {
        this.fields = fieldFactory.createFields();
    }

    @Override
    public void accept(MetaDataModelVisitor modelVisitor) {
    }

    @Override
    public List<MetaDataField> getFields() {
        return this.fields;
    }

    @Override
    public MetaDataField getFieldByName(String name) {
        for (MetaDataField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultStructuredMetadataModel that = (DefaultStructuredMetadataModel)o;
        return !(this.fields != null ? !((Object)this.fields).equals(that.fields) : that.fields != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        return result;
    }
}

