/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONPointerType
implements JSONType {
    private static final String ID = "id";
    public static final String HASH = "#";
    private String ref;
    private SchemaEnv env;

    public JSONPointerType(SchemaEnv env, String reference) {
        this.ref = reference;
        this.env = env;
    }

    public JSONType resolve() {
        JSONType referenceType = null;
        String baseURI = "";
        String jsonPointer = HASH;
        String[] splitRef = this.ref.split(HASH);
        JSONObject literalRef = this.findAnyObjectWithId(this.env.getContextJsonObject(), this.ref);
        if (literalRef != null) {
            referenceType = this.env.evaluate(literalRef);
            this.env.addType(this.ref, referenceType);
        } else {
            switch (splitRef.length) {
                case 1: {
                    baseURI = splitRef[0];
                    jsonPointer = HASH;
                    break;
                }
                case 2: {
                    baseURI = splitRef[0];
                    jsonPointer = splitRef[1];
                }
            }
            SchemaEnv environment = this.env;
            if (!baseURI.isEmpty()) {
                JSONObject remoteSchema;
                try {
                    URL url = new URL(baseURI);
                    remoteSchema = this.getRemoteSchema(url);
                    environment = this.createSchemaEnv(this.env, remoteSchema, url);
                }
                catch (MalformedURLException e) {
                    URL contextJsonURL = this.env.getContextJsonURL();
                    try {
                        URL urlFile = new URL(contextJsonURL, baseURI);
                        remoteSchema = this.getRemoteSchema(urlFile);
                        environment = this.createSchemaEnv(this.env, remoteSchema, urlFile);
                    }
                    catch (MalformedURLException e1) {
                        throw new SchemaException(e1);
                    }
                }
            }
            if (HASH.equals(jsonPointer)) {
                referenceType = environment.lookupType(HASH);
            } else {
                JSONObject jsonObjectToken;
                JSONObject contextJsonObject = environment.getContextJsonObject();
                if (baseURI.equals("") || contextJsonObject.has(ID) && baseURI.equals(contextJsonObject.get(ID))) {
                    referenceType = environment.lookupType(jsonPointer);
                }
                if (referenceType == null && (jsonObjectToken = this.findByPath(jsonPointer, contextJsonObject)) != null) {
                    referenceType = environment.evaluate(jsonObjectToken);
                    environment.addType(jsonPointer, referenceType);
                }
            }
        }
        return referenceType;
    }

    private JSONObject findAnyObjectWithId(JSONObject contextJsonObject, String id) {
        JSONObject result = null;
        if (contextJsonObject.has(ID) && contextJsonObject.get(ID).equals(id)) {
            result = contextJsonObject;
        } else {
            Iterator keys = contextJsonObject.keys();
            while (keys.hasNext() && result == null) {
                String nextKey;
                Object nextValue;
                Object next = keys.next();
                if (!(next instanceof String) || !((nextValue = contextJsonObject.get(nextKey = (String)next)) instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)nextValue;
                result = this.findAnyObjectWithId(jsonObject, id);
            }
        }
        return result;
    }

    private JSONObject findByPath(String jsonPointer, JSONObject contextJsonObject) {
        JSONObject jsonObjectToken = contextJsonObject;
        String[] tokens = jsonPointer.split("/");
        JSONObject result = null;
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!jsonObjectToken.has(token)) {
                result = null;
                break;
            }
            result = jsonObjectToken = (JSONObject)jsonObjectToken.get(token);
        }
        return result;
    }

    private SchemaEnv createSchemaEnv(SchemaEnv parentEnv, JSONObject remoteSchema, URL contextUrl) {
        SchemaEnv environment = new SchemaEnv(parentEnv, remoteSchema, contextUrl);
        JSONType rootType = environment.evaluate(remoteSchema);
        environment.addType(HASH, rootType);
        return environment;
    }

    public JSONObject getRemoteSchema(URL url) {
        block14: {
            String urlProtocol = url.getProtocol();
            if (urlProtocol.equals("file")) {
                JSONObject jSONObject;
                if (!url.toURI().isAbsolute()) break block14;
                InputStream input = null;
                try {
                    JSONObject refSchemaObject;
                    input = url.openStream();
                    String fileSchemaString = IOUtils.toString((InputStream)input);
                    jSONObject = refSchemaObject = new JSONObject(fileSchemaString);
                }
                catch (IOException e) {
                    try {
                        try {
                            throw new SchemaException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly((InputStream)input);
                            throw throwable;
                        }
                    }
                    catch (URISyntaxException e2) {
                        e2.printStackTrace();
                    }
                }
                IOUtils.closeQuietly((InputStream)input);
                return jSONObject;
            } else if (urlProtocol.equals("http") || urlProtocol.equals("https")) {
                JSONObject jSONObject;
                BufferedReader rd = null;
                try {
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    String result = IOUtils.toString((Reader)rd);
                    jSONObject = new JSONObject(result);
                }
                catch (IOException e) {
                    try {
                        throw new SchemaException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(rd);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)rd);
                return jSONObject;
            }
        }
        return null;
    }

    @Override
    public boolean contains(Object obj) {
        return false;
    }

    @Override
    public String explain(Object obj) {
        return null;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isJSONPrimitive() {
        return false;
    }

    @Override
    public boolean isJSONArray() {
        return false;
    }

    @Override
    public boolean isJSONObject() {
        return false;
    }

    @Override
    public boolean isJSONPointer() {
        return true;
    }
}

