/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.mulesoft.common.io.AsyncFile;
import org.mulesoft.common.test.Diff;
import org.mulesoft.common.test.Diff$;
import org.mulesoft.common.test.Files$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.Succeeded$;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class Tests$ {
    public static Tests$ MODULE$;
    private final ExecutionContext executionContext;

    static {
        new Tests$();
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    public boolean assertEquals(File outFile, File goldenFile) {
        boolean bl;
        try {
            bl = Diff$.MODULE$.trimming().diff(new FileReader(outFile), new FileReader(goldenFile)).isEmpty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public <T> T assertNotNull(T e) {
        Matchers$.MODULE$.convertToAnyShouldWrapper(e, new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.not()).equal(null);
        return e;
    }

    public void checkDiff(File outFile, File goldenFile) {
        Option<String> difference = this.diff(outFile, goldenFile);
        if (difference.isDefined()) {
            Predef$.MODULE$.println((Object)"DIFF!!");
            Predef$.MODULE$.println(difference.get());
        }
        difference.map((Function1 & Serializable & scala.Serializable)s -> Matchers$.MODULE$.fail(s, new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44)));
    }

    public Assertion checkDiff(Tuple2<String, String> tuple) {
        Tuple2<String, String> tuple2 = tuple;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String actual = (String)tuple2._1();
        String expected = (String)tuple2._2();
        this.checkDiff(actual, expected);
        Succeeded$ succeeded$ = Succeeded$.MODULE$;
        return succeeded$;
    }

    public Assertion checkDiffIgnoreAllSpaces(Tuple2<String, String> tuple) {
        Tuple2<String, String> tuple2 = tuple;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String actual = (String)tuple2._1();
        String expected = (String)tuple2._2();
        this.checkDiffIgnoreAllSpaces(actual, expected);
        Succeeded$ succeeded$ = Succeeded$.MODULE$;
        return succeeded$;
    }

    public void checkDiff(String actual, String expected) {
        List<Diff.Delta<String>> diffs = Diff$.MODULE$.trimming().ignoreEmptyLines().diff(actual, expected);
        if (diffs.nonEmpty()) {
            Predef$.MODULE$.println((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            Predef$.MODULE$.println((Object)expected);
            Predef$.MODULE$.println((Object)"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            Predef$.MODULE$.println((Object)actual);
            Predef$.MODULE$.println((Object)"==============================================");
            throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(1).append("\n").append(Diff$.MODULE$.makeString(diffs)).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }
    }

    public void checkDiffIgnoreAllSpaces(String actual, String expected) {
        List<Diff.Delta<String>> diffs = Diff$.MODULE$.ignoreAllSpace().diff(actual, expected);
        if (diffs.nonEmpty()) {
            Predef$.MODULE$.println((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            Predef$.MODULE$.println((Object)expected);
            Predef$.MODULE$.println((Object)"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            Predef$.MODULE$.println((Object)actual);
            Predef$.MODULE$.println((Object)"==============================================");
            throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(1).append("\n").append(Diff$.MODULE$.makeString(diffs)).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }
    }

    public void checkDiff(File outFile, File goldenFile, Diff.Equals<String> comparator) {
        List<Diff.Delta<String>> diffs = Diff$.MODULE$.stringDiffer(comparator).ignoreEmptyLines().diff(outFile, goldenFile);
        if (diffs.nonEmpty()) {
            throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(18).append("\ndiff -y -W 150 ").append(outFile).append(" ").append(goldenFile).append("\n").append(Diff$.MODULE$.makeString(diffs)).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }
    }

    public Option<String> diff(File outFile, File goldenFile) {
        if (!goldenFile.exists()) {
            throw Matchers$.MODULE$.fail(String.format("Cannot Open Golden File: \n%s\nfor comparing \n%s", goldenFile.getAbsolutePath(), outFile.getAbsolutePath()), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }
        try {
            this.diff(new FileReader(outFile), outFile.toString(), new FileReader(goldenFile), goldenFile.toString());
        }
        catch (FileNotFoundException e) {
            throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(35).append("Cannot Open Target or Golden File: ").append(e.getMessage()).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }
        return Option$.MODULE$.empty();
    }

    public List<Object> listFiles(String dirName, String pattern) {
        return this.listFiles(new File(dirName), pattern);
    }

    public List<Object> listFiles(File dir, String pattern) {
        return (List)Files$.MODULE$.list(dir, pattern).map((Function1 & Serializable & scala.Serializable)path -> (File[])((Object[])new File[]{new File((String)path)}), List$.MODULE$.canBuildFrom());
    }

    public String randomString(int length) {
        Random r = new Random();
        StringBuilder result = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach((Function1)result.append((char)(97 + r.nextInt(25))));
        return result.toString();
    }

    public void sleep(int millis) {
        System.out.printf("Sleeping %s ms....", ((Object)BoxesRunTime.boxToInteger((int)millis)).toString());
        Thread.sleep(millis);
        System.out.println("\r ");
    }

    public List<Object> wrapForParameters(Object args) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(args).map((Function1 & Serializable & scala.Serializable)arg -> Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg}), ClassTag$.MODULE$.apply(Object.class)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)))))).toList();
    }

    public String getHostName() {
        String string;
        try {
            String host = InetAddress.getLocalHost().getHostName().replaceAll("-", "");
            string = host.substring(0, Math.min(this.index(host, '.'), Math.min(this.index(host, '_'), this.index(host, '-'))));
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return string;
    }

    public Future<Assertion> checkLinesDiff(AsyncFile a, AsyncFile e, String encoding) {
        return ((Future)a.read(encoding, this.executionContext())).zip((Future)e.read(encoding, this.executionContext())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future<Assertion> future;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CharSequence actual = (CharSequence)tuple2._1();
                CharSequence expected = (CharSequence)tuple2._2();
                Set actualLines = ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(((Object)actual).toString())).linesIterator().toSeq().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Seq$.MODULE$.canBuildFrom())).toSet();
                Set expectedLines = ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(((Object)expected).toString())).linesIterator().toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Seq$.MODULE$.canBuildFrom())).toSet();
                Set set = actualLines;
                Set set2 = expectedLines;
                if (set == null ? set2 != null : !set.equals(set2)) {
                    Set diff = (Set)actualLines.diff((GenSet)expectedLines);
                    System.err.println("Not matching lines");
                    diff.foreach((Function1 & Serializable & scala.Serializable)l -> {
                        System.err.println(l);
                        return BoxedUnit.UNIT;
                    });
                    future = MODULE$.checkDiff(a, e, MODULE$.checkDiff$default$3());
                } else {
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                        Set $org_scalatest_assert_macro_left = actualLines;
                        Set $org_scalatest_assert_macro_right = expectedLines;
                        Set set = $org_scalatest_assert_macro_left;
                        Set set2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                        return Matchers$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                    }, MODULE$.executionContext());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Future<Assertion> future2 = future;
            return future2;
        }, this.executionContext());
    }

    public String checkLinesDiff$default$3() {
        return "UTF-8";
    }

    public Future<Assertion> checkDiff(AsyncFile a, AsyncFile e, String encoding) {
        return ((Future)a.read(encoding, this.executionContext())).zip((Future)e.read(encoding, this.executionContext())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            CharSequence actual = (CharSequence)tuple2._1();
            CharSequence expected = (CharSequence)tuple2._2();
            List<Diff.Delta<String>> diffs = Diff$.MODULE$.ignoreAllSpace().diff(((Object)actual).toString(), ((Object)expected).toString());
            if (diffs.nonEmpty()) {
                if (!MODULE$.goldenOverride()) throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(20).append("\ndiff -y -W 150 ").append(a).append(" ").append(e).append(" \n\n").append(Diff$.MODULE$.makeString(diffs)).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
                boxedUnit = ((Future)a.read(encoding, MODULE$.executionContext())).map((Function1 & Serializable & scala.Serializable)content -> (Future)e.write((CharSequence)((Object)content).toString(), encoding, MODULE$.executionContext()), MODULE$.executionContext());
                return Matchers$.MODULE$.succeed();
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Matchers$.MODULE$.succeed();
        }, this.executionContext());
    }

    private boolean goldenOverride() {
        return Option$.MODULE$.apply((Object)System.getProperty("golden.override")).isDefined();
    }

    public Assertion checkDiff(String a, String fileA, String b, String fileB) {
        List<Diff.Delta<String>> diffs = Diff$.MODULE$.ignoreAllSpace().diff(a, b);
        if (diffs.nonEmpty()) {
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(3).append("A: ").append(fileA).toString());
            Predef$.MODULE$.println((Object)a);
            Predef$.MODULE$.println((Object)"\n\n\n\n\n\n");
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(3).append("B: ").append(fileB).toString());
            Predef$.MODULE$.println((Object)b);
            throw Matchers$.MODULE$.fail(new java.lang.StringBuilder(18).append("\ndiff -y -W 150 ").append(this.trimFileProtocol(fileA)).append(" ").append(this.trimFileProtocol(fileB)).append("\n").append(Diff$.MODULE$.makeString(diffs)).toString(), new Position("Tests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        }
        return Succeeded$.MODULE$;
    }

    public String checkDiff$default$3() {
        return "UTF-8";
    }

    public Option<String> diff(Reader a, String aName, Reader b, String bName) {
        List<Diff.Delta<String>> diffs = Diff$.MODULE$.ignoreAllSpace().diff(a, b);
        return diffs.isEmpty() ? Option$.MODULE$.empty() : Option$.MODULE$.apply((Object)new java.lang.StringBuilder(18).append("\ndiff -y -W 150 ").append(aName).append(" ").append(bName).append("\n").append(Diff$.MODULE$.makeString(diffs)).toString());
    }

    /*
     * WARNING - void declaration
     */
    private int index(String s, char chr) {
        void var3_3;
        int n = s.indexOf(chr);
        return n <= 0 ? s.length() : var3_3;
    }

    private String trimFileProtocol(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(name)).stripPrefix("file://"))).stripPrefix("file:/");
    }

    private Tests$() {
        MODULE$ = this;
        this.executionContext = ExecutionContext.Implicits$.MODULE$.global();
    }
}

