/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.net;

import java.io.Serializable;
import org.mulesoft.common.net.DomainValidator$;
import org.mulesoft.common.net.Email;
import org.mulesoft.common.net.InetAddress$;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.package$;
import org.mulesoft.common.parse.package$ParseResult$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.matching.Regex;

public final class Email$
implements Serializable {
    public static final Email$ MODULE$ = new Email$();
    private static final Regex EmailRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*(.+)@(.+?)\\s*$"));
    private static final Regex IpDomainRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\[(.*)\\]$"));
    private static final Regex UserRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*(((\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|\"(\\\\\"|[^\"])*\")(\\.(((\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|\"(\\\\\"|[^\"])*\"))*$"));

    public Either<ParseError, Email> parse(String user, String domain) {
        if (!this.userIsValid(user)) {
            return ParseError$.MODULE$.formatError(user, "Invalid User");
        }
        if (!this.domainIsValid(domain)) {
            return ParseError$.MODULE$.formatError(domain, "Invalid domain");
        }
        return scala.package$.MODULE$.Right().apply((Object)new Email(user, domain));
    }

    public Either<ParseError, Email> parse(String email) {
        if (email != null && !email.endsWith(".")) {
            Option option;
            String string = email;
            if (string != null && !(option = this.EmailRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
                String user = (String)((LinearSeqOps)option.get()).apply(0);
                String domain = (String)((LinearSeqOps)option.get()).apply(1);
                return this.parse(user, domain);
            }
        }
        return ParseError$.MODULE$.formatError(email, ParseError$.MODULE$.formatError$default$2());
    }

    public Email apply(String user, String domain) {
        return package$ParseResult$.MODULE$.result$extension(package$.MODULE$.ParseResult(this.parse(user, domain)));
    }

    public Email apply(String email) {
        return package$ParseResult$.MODULE$.result$extension(package$.MODULE$.ParseResult(this.parse(email)));
    }

    public Option<Email> unapply(String arg) {
        return this.parse(arg).toOption();
    }

    private boolean domainIsValid(String domain) {
        Option option;
        String string = domain;
        if (string != null && !(option = this.IpDomainRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String address = (String)((LinearSeqOps)option.get()).apply(0);
            return InetAddress$.MODULE$.parse(address).isRight();
        }
        return DomainValidator$.MODULE$.isValid(domain, DomainValidator$.MODULE$.isValid$default$2());
    }

    public boolean userIsValid(String user) {
        return user != null && user.length() <= 64 && this.UserRegex().pattern().matcher(user).matches();
    }

    private final Regex EmailRegex() {
        return EmailRegex;
    }

    private final Regex IpDomainRegex() {
        return IpDomainRegex;
    }

    private final String ValidChar() {
        return "(\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    }

    private final String QuotedUser() {
        return "\"(\\\\\"|[^\"])*\"";
    }

    private final String Word() {
        return "(((\\\\[^ \"\\\\])|[^\\s\\x00-\\x1F\\x7F\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|\"(\\\\\"|[^\"])*\")";
    }

    private final Regex UserRegex() {
        return UserRegex;
    }

    private final int MaxUserLength() {
        return 64;
    }

    public Option<Tuple2<String, String>> unapply(Email x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.user(), (Object)x$0.domain()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Email$.class);
    }

    private Email$() {
    }
}

