/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.net;

import java.io.Serializable;
import org.mulesoft.common.core.package$Strings$;
import org.mulesoft.common.net.InetAddress;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.package$ParseResult$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Right;
import scala.util.matching.Regex;

public final class InetAddress$
implements Serializable {
    public static final InetAddress$ MODULE$ = new InetAddress$();
    private static final Regex Ipv4Regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(0|[1-9]\\d{0,2}).(0|[1-9]\\d{0,2}).(0|[1-9]\\d{0,2}).(0|[1-9]\\d{0,2})$"));

    public Either<ParseError, InetAddress> parse(String address) {
        Either<ParseError, InetAddress> r = this.parseAsIPv4(address);
        if (r.isRight()) {
            return r;
        }
        if (address.indexOf(58) == -1) {
            return r;
        }
        return this.parseAsIPv6(address);
    }

    public Either<ParseError, InetAddress> parseAsIPv4(String address) {
        Right right;
        Object object = new Object();
        try {
            Option option;
            String string = address;
            if (string != null && !(option = this.Ipv4Regex().unapplySeq((CharSequence)string)).isEmpty()) {
                Seq groups = (Seq)option.get();
                Builder r = package$.MODULE$.List().newBuilder();
                groups.foreach((Function1 & Serializable)group -> {
                    int g = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(group));
                    if (g > 255) {
                        throw new NonLocalReturnControl(object, ParseError$.MODULE$.rangeError(g));
                    }
                    return (Builder)r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)g));
                });
                right = package$.MODULE$.Right().apply((Object)this.apply(false, (List<Object>)((List)r.result())));
            } else {
                right = ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                right = (Right)ex.value();
            }
            throw ex;
        }
        return right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<ParseError, InetAddress> parseAsIPv6(String address) {
        Either either;
        Object object = new Object();
        try {
            String[] groups;
            int ipv4N;
            if (package$Strings$.MODULE$.isNullOrEmpty$extension(org.mulesoft.common.core.package$.MODULE$.Strings(address))) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int doubleColon = address.indexOf("::");
            if (doubleColon != -1 && address.indexOf("::", doubleColon + 1) != -1) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int lastColon = address.lastIndexOf(58);
            if (lastColon == -1) {
                return ParseError$.MODULE$.formatError(address, ParseError$.MODULE$.formatError$default$2());
            }
            int n = ipv4N = address.indexOf(46, lastColon) == -1 ? 0 : 1;
            if (doubleColon == -1) {
                v1 = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(address), ':');
            } else {
                String[] head = InetAddress$.split$1(address.substring(0, doubleColon));
                String[] tail = InetAddress$.split$1(address.substring(doubleColon + 2));
                v1 = groups = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])head), Array$.MODULE$.fill(8 - head.length - tail.length - ipv4N, (Function0 & Serializable)() -> "0", ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class))), (Object)tail, ClassTag$.MODULE$.apply(String.class));
            }
            if (groups.length + ipv4N != 8) {
                return ParseError$.MODULE$.formatError(address, "Wrong number of groups");
            }
            Builder r = package$.MODULE$.List().newBuilder();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), groups.length - ipv4N).foreach((Function1 & Serializable)i -> InetAddress$.$anonfun$parseAsIPv6$2(groups, object, r, BoxesRunTime.unboxToInt((Object)i)));
            if (ipv4N == 1) {
                Either<ParseError, InetAddress> either2 = this.parseAsIPv4((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])groups)));
                if (!(either2 instanceof Right)) return either2;
                Right right = (Right)either2;
                InetAddress ia = (InetAddress)right.value();
                r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)((BoxesRunTime.unboxToInt((Object)ia.groups().apply(0)) << 8) + BoxesRunTime.unboxToInt((Object)ia.groups().apply(1)))));
                v2 = (Builder)r.$plus$eq((Object)BoxesRunTime.boxToInteger((int)((BoxesRunTime.unboxToInt((Object)ia.groups().apply(2)) << 8) + BoxesRunTime.unboxToInt((Object)ia.groups().apply(3)))));
            } else {
                v2 = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)this.apply(true, (List<Object>)((List)r.result())));
            return either;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            either = (Either)ex.value();
            return either;
        }
    }

    public InetAddress ipv4(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parseAsIPv4(address)));
    }

    public InetAddress ipv6(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parseAsIPv6(address)));
    }

    public InetAddress apply(String address) {
        return package$ParseResult$.MODULE$.result$extension(org.mulesoft.common.parse.package$.MODULE$.ParseResult(this.parse(address)));
    }

    private final String Ipv4Group() {
        return "(0|[1-9]\\d{0,2})";
    }

    private final Regex Ipv4Regex() {
        return Ipv4Regex;
    }

    private final int Ipv4MaxOctetValue() {
        return 255;
    }

    private final int Ipv6Groups() {
        return 8;
    }

    private final int Ipv6MaxGroupValue() {
        return 65535;
    }

    public InetAddress apply(boolean ipv6, List<Object> groups) {
        return new InetAddress(ipv6, groups);
    }

    public Option<Tuple2<Object, List<Object>>> unapply(InetAddress x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x$0.ipv6()), x$0.groups()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InetAddress$.class);
    }

    private static final String[] split$1(String s) {
        if (s.isEmpty()) {
            return (String[])((Object[])new String[]{"0"});
        }
        return StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(s), ':');
    }

    public static final /* synthetic */ Builder $anonfun$parseAsIPv6$2(String[] groups$1, Object nonLocalReturnKey2$1, Builder r$2, int i) {
        Builder builder;
        String g = groups$1[i];
        try {
            int v = Integer.parseInt(g, 16);
            if (v > 65535) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, ParseError$.MODULE$.rangeError(v));
            }
            builder = (Builder)r$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)v));
        }
        catch (Exception exception) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, ParseError$.MODULE$.formatError(g, ParseError$.MODULE$.formatError$default$2()));
        }
        return builder;
    }

    private InetAddress$() {
    }
}

