/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.common.time;

import java.io.Serializable;
import org.mulesoft.common.core.package$Strings$;
import org.mulesoft.common.parse.ParseError;
import org.mulesoft.common.parse.ParseError$;
import org.mulesoft.common.parse.ParseException;
import org.mulesoft.common.parse.RangeError;
import org.mulesoft.common.time.SimpleDateTime;
import org.mulesoft.common.time.TimeOfDay;
import org.mulesoft.common.time.TimeOfDay$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.matching.Regex;

public final class SimpleDateTime$
implements Serializable {
    public static final SimpleDateTime$ MODULE$ = new SimpleDateTime$();
    private static final TimeOfDay ZeroTime = new TimeOfDay(0, TimeOfDay$.MODULE$.apply$default$2(), TimeOfDay$.MODULE$.apply$default$3(), TimeOfDay$.MODULE$.apply$default$4());
    private static final SimpleDateTime Epoch = new SimpleDateTime(1970, 1, 1, (Option<TimeOfDay>)new Some((Object)MODULE$.ZeroTime()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
    private static final String datePattern = "(\\d{4})-(\\d\\d?)-(\\d\\d?)";
    private static final String timePattern = "(\\d\\d?):(\\d\\d?)(?::(\\d\\d?))?(?:\\.(\\d{0,9}))?";
    private static final String timeZonePattern = "(?:(?:[\\ \\t]*)?(Z|([-+]\\d\\d?)(?::(\\d\\d?))?))?";
    private static final String timeSeparation = "(?:[Tt]|[\\ \\t]+)";
    private static final Regex dateRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(MODULE$.datePattern()));
    private static final Regex dateTimeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(MODULE$.datePattern() + "(?:" + MODULE$.timeSeparation() + MODULE$.timePattern() + MODULE$.timeZonePattern() + ")?"));
    private static final Regex partialTimeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(MODULE$.timePattern()));
    private static final Regex fullTimeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(MODULE$.timePattern() + MODULE$.timeZonePattern()));

    public Option<TimeOfDay> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public TimeOfDay ZeroTime() {
        return ZeroTime;
    }

    public SimpleDateTime Epoch() {
        return Epoch;
    }

    private String datePattern() {
        return datePattern;
    }

    private String timePattern() {
        return timePattern;
    }

    private String timeZonePattern() {
        return timeZonePattern;
    }

    private String timeSeparation() {
        return timeSeparation;
    }

    private Regex dateRegex() {
        return dateRegex;
    }

    private Regex dateTimeRegex() {
        return dateTimeRegex;
    }

    private Regex partialTimeRegex() {
        return partialTimeRegex;
    }

    private Regex fullTimeRegex() {
        return fullTimeRegex;
    }

    private int toInt(String s) {
        if (package$Strings$.MODULE$.isNullOrEmpty$extension(org.mulesoft.common.core.package$.MODULE$.Strings(s))) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public SimpleDateTime apply(int year, int month, int day) {
        return new SimpleDateTime(year, month, day, (Option<TimeOfDay>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public SimpleDateTime apply(int year, int month, int day, TimeOfDay timeOfDay) {
        return new SimpleDateTime(year, month, day, (Option<TimeOfDay>)new Some((Object)timeOfDay), (Option<Object>)None$.MODULE$);
    }

    public SimpleDateTime apply(int year, int month, int day, TimeOfDay timeOfDay, int zoneOffset) {
        return new SimpleDateTime(year, month, day, (Option<TimeOfDay>)new Some((Object)timeOfDay), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)(zoneOffset * 60))));
    }

    public Option<TimeOfDay> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<SimpleDateTime> unapply(String arg) {
        return this.parse(arg).toOption();
    }

    public Either<ParseError, SimpleDateTime> parse(String str) {
        Option option;
        String string = str;
        if (string != null && !(option = this.dateTimeRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(10) == 0) {
            String year = (String)((LinearSeqOps)option.get()).apply(0);
            String month = (String)((LinearSeqOps)option.get()).apply(1);
            String day = (String)((LinearSeqOps)option.get()).apply(2);
            String hours = (String)((LinearSeqOps)option.get()).apply(3);
            String minutes = (String)((LinearSeqOps)option.get()).apply(4);
            String seconds = (String)((LinearSeqOps)option.get()).apply(5);
            String nanos = (String)((LinearSeqOps)option.get()).apply(6);
            String z = (String)((LinearSeqOps)option.get()).apply(7);
            String offsetHours = (String)((LinearSeqOps)option.get()).apply(8);
            String offsetMinutes = (String)((LinearSeqOps)option.get()).apply(9);
            return this.either((Function0 & Serializable)() -> new SimpleDateTime(MODULE$.toInt(year), MODULE$.toInt(month), MODULE$.toInt(day), (Option<TimeOfDay>)(hours == null ? None$.MODULE$ : new Some((Object)MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos))), MODULE$.buildTimeZone(z, offsetHours, offsetMinutes)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, SimpleDateTime> parseDate(String str) {
        Option option;
        String string = str;
        if (string != null && !(option = this.dateRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String year = (String)((LinearSeqOps)option.get()).apply(0);
            String month = (String)((LinearSeqOps)option.get()).apply(1);
            String day = (String)((LinearSeqOps)option.get()).apply(2);
            return this.either((Function0 & Serializable)() -> MODULE$.apply(MODULE$.toInt(year), MODULE$.toInt(month), MODULE$.toInt(day)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, Tuple2<TimeOfDay, Option<Object>>> parseFullTime(String str) {
        Option option;
        String string = str;
        if (string != null && !(option = this.fullTimeRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(7) == 0) {
            String hours = (String)((LinearSeqOps)option.get()).apply(0);
            String minutes = (String)((LinearSeqOps)option.get()).apply(1);
            String seconds = (String)((LinearSeqOps)option.get()).apply(2);
            String nanos = (String)((LinearSeqOps)option.get()).apply(3);
            String z = (String)((LinearSeqOps)option.get()).apply(4);
            String offsetHours = (String)((LinearSeqOps)option.get()).apply(5);
            String offsetMinutes = (String)((LinearSeqOps)option.get()).apply(6);
            return this.either((Function0 & Serializable)() -> new Tuple2((Object)MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos), MODULE$.buildTimeZone(z, offsetHours, offsetMinutes)));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public Either<ParseError, TimeOfDay> parsePartialTime(String str) {
        Option option;
        String string = str;
        if (string != null && !(option = this.partialTimeRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(4) == 0) {
            String hours = (String)((LinearSeqOps)option.get()).apply(0);
            String minutes = (String)((LinearSeqOps)option.get()).apply(1);
            String seconds = (String)((LinearSeqOps)option.get()).apply(2);
            String nanos = (String)((LinearSeqOps)option.get()).apply(3);
            return this.either((Function0 & Serializable)() -> MODULE$.buildTimeOfDay(hours, minutes, seconds, nanos));
        }
        return ParseError$.MODULE$.formatError(str, ParseError$.MODULE$.formatError$default$2());
    }

    public void org$mulesoft$common$time$SimpleDateTime$$validateDate(int year, int month, int day) {
        int n;
        if (year == 0) {
            n = year;
        } else if (month < 1 || month > 12) {
            n = month;
        } else if (day < 1 || day > 31) {
            n = day;
        } else if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            n = day;
        } else if (month == 2 && (day > 29 || day == 29 && (year % 4 != 0 || year >= 1600 && year % 100 == 0 && year % 400 != 0))) {
            n = day;
        } else {
            return;
        }
        int offending = n;
        throw new ParseException(new RangeError(offending));
    }

    private TimeOfDay buildTimeOfDay(String hours, String minutes, String seconds, String nanos) {
        return new TimeOfDay(Integer.parseInt(hours), Integer.parseInt(minutes), this.toInt(seconds), nanos == null ? 0 : Integer.parseInt(nanos + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 9 - nanos.length())));
    }

    private Option<Object> buildTimeZone(String z, String offsetHours, String offsetMinutes) {
        if (z == null) {
            return None$.MODULE$;
        }
        if (offsetHours == null) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }
        int oh = this.toInt(offsetHours);
        int om = this.toInt(offsetMinutes);
        if (oh < -24 || oh > 24) {
            throw new ParseException(new RangeError(oh));
        }
        if (om < 0 || om > 60) {
            throw new ParseException(new RangeError(om));
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)(oh * 3600 + (oh < 0 ? -om : om) * 60)));
    }

    public String org$mulesoft$common$time$SimpleDateTime$$zoneOffsetToString(int zoneOffset) {
        if (zoneOffset == 0) {
            return "Z";
        }
        int hours = zoneOffset / 3600;
        int minutes = zoneOffset / 60 % 60;
        String sign = zoneOffset > 0 ? "+" : "-";
        String mins = minutes == 0 ? "" : StringOps$.MODULE$.format$extension(":%02d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(minutes)))}));
        return StringOps$.MODULE$.format$extension("%s%02d%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sign, BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(hours))), mins}));
    }

    private <T> Either<ParseError, T> either(Function0<T> r) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(r.apply());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ParseException) {
                ParseException parseException = (ParseException)throwable2;
                ParseError e = parseException.parseError();
                right = package$.MODULE$.Left().apply((Object)e);
            }
            throw throwable;
        }
        return right;
    }

    public SimpleDateTime apply(int year, int month, int day, Option<TimeOfDay> timeOfDay, Option<Object> zoneOffset) {
        return new SimpleDateTime(year, month, day, timeOfDay, zoneOffset);
    }

    public Option<Tuple5<Object, Object, Object, Option<TimeOfDay>, Option<Object>>> unapply(SimpleDateTime x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.year()), (Object)BoxesRunTime.boxToInteger((int)x$0.month()), (Object)BoxesRunTime.boxToInteger((int)x$0.day()), x$0.timeOfDay(), x$0.zoneOffset()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SimpleDateTime$.class);
    }

    private SimpleDateTime$() {
    }
}

