package org.mule.commons.atlantic.execution.builder;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.lambda.function.HexaFunction;
import org.mule.commons.atlantic.lambda.function.PentaFunction;

import java.util.List;

/**
 * {@link GenericFunctionExecutionBuilder} for {@link HexaFunction} instances.
 *
 * @param <A>      The first parameter.
 * @param <B>      The second parameter.
 * @param <C>      The third parameter.
 * @param <D>      The fourth parameter.
 * @param <E>      The fifth parameter.
 * @param <F>      The sixth parameter.
 * @param <RESULT> The type of the result of the {@link HexaFunction}
 */
public class HexaFunctionExecutionBuilder<A, B, C, D, E, F, RESULT> extends GenericFunctionExecutionBuilder<A, HexaFunction<A, B, C, D, E, F, RESULT>, PentaFunction<B, C, D, E, F, RESULT>, PentaFunctionExecutionBuilder<B, C, D, E, F, RESULT>, RESULT> {

    /**
     * Default constructor.
     *
     * @param lambda  The {@link HexaFunction} to execute.
     * @param params  The parameters already accumulated when creating this ExecutionBuilder.
     * @param context The {@link ExecutionContext} that contains all the listeners and handlers of the execution.
     */
    public HexaFunctionExecutionBuilder(HexaFunction<A, B, C, D, E, F, RESULT> lambda, List<Object> params, ExecutionContext context) {
        super(lambda, params, context, PentaFunctionExecutionBuilder::new);
    }
}
