package org.mule.commons.atlantic.execution.context.executor;

import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.execution.context.exception.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.context.listener.PostExecutionListener;
import org.mule.commons.atlantic.execution.context.listener.PreExecutionListener;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

import java.util.List;

/**
 * An Executor is responsible for executing the provided {@link Supplier} over the provided {@link ExecutionContext}.
 *
 * @param <RESULT> The type of result returned by the execution.
 */
public interface Executor<RESULT> {

    /**
     * Executes the passed {@link Supplier} over the provided {@link ExecutionContext}.
     *
     * @param lambda                 The operation to execute.
     * @param params                 The parameters of the operation. For instance methods, the first parameter is the instance
     *                               executing the method.
     * @param preExecutionListeners  The listeners to be run before the operation is executed.
     * @param postExecutionListeners The listeners to be run after the operation is executed.
     * @param exceptionHandlers      The handlers for the exceptions.
     * @return Object The result.
     */
    RESULT execute(Supplier<RESULT> lambda,
                            List<Object> params,
                            List<PreExecutionListener> preExecutionListeners,
                            List<PostExecutionListener<RESULT>> postExecutionListeners,
                            List<DefinedExceptionHandler<?>> exceptionHandlers);
}
