package org.mule.commons.atlantic.execution.context.listener;

import java.util.List;

/**
 * Listener that executes before the operation is executed.
 */
public interface PreExecutionListener {

    /**
     * Method called before the operation is executed.
     *
     * @param params The parameters of the operation. For instance methods, the first parameter is the instance
     *               executing the method.
     */
    void onPreExecute(List<Object> params);
}
