package org.mule.commons.atlantic.lambda.consumer;

import org.mule.commons.atlantic.lambda.function.BiFunction;

/**
 * Represents an operation that accepts two input arguments and returns no result.  This is the two-arity specialization
 * of {@link Consumer}.
 * Unlike most other functional interfaces, {@code BiConsumer} is expected to operate via side-effects.
 *
 * This is a functional interface whose functional method is {@link #accept(Object, Object)}.
 *
 * @param <A> The type of the first argument to the operation.
 * @param <B> The type of the second argument to the operation.
 */
@FunctionalInterface
public interface BiConsumer<A, B> extends AtlanticConsumer<BiFunction<A, B, Void>> {

    /**
     * Performs this operation on the given arguments.
     *
     * @param a The first input argument.
     * @param b The second input argument.
     * @throws Throwable Any exception that the operation will throw.
     */
    void accept(A a, B b) throws Throwable;

    @Override
    default BiFunction<A, B, Void> toFunction() {
        return (a, b) -> {
            accept(a, b);
            return null;
        };
    }
}
