package org.mule.commons.atlantic.lambda.function;

import org.mule.commons.atlantic.lambda.AtlanticLambda;

/**
 * Interface that identifies a Functional interface as a function that receives one or more parameters.
 * Atlantic Functions can be downgraded to a different type of {@link AtlanticLambda} by fixing up it's first parameter.
 *
 * @param <PARAM>  The first parameter of the lambda.
 * @param <NEXT>   The downgraded {@link AtlanticLambda}
 */
public interface AtlanticFunction<PARAM, NEXT extends AtlanticLambda> extends AtlanticLambda {

    /**
     * Converts this {@link AtlanticFunction} into another that has the same parameters save for the first one. Invocation
     * of the returned {@link AtlanticLambda} will call this one with the provided parameter.
     *
     * @param param The parameter that will be passed to this {@link AtlanticFunction}.
     * @return AtlanticLambda This lambda without the first parameter.
     */
    NEXT downgrade(PARAM param);
}
